/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.settings;

import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public enum RelativeDirection implements StringRepresentable,
TranslatableEnum
{
    NONE("none", " "),
    DOWN("down", "\u25bc"),
    UP("up", "\u25b2"),
    LEFT("left", "\u25c0"),
    RIGHT("right", "\u25b6"),
    FRONT("front", "\u25a3"),
    BACK("back", "\u25a4");

    private final String name;
    private final String symbol;

    private RelativeDirection(String name, String symbol) {
        this.name = name;
        this.symbol = symbol;
    }

    public Direction toAbsolute(Direction current) {
        return switch (this.ordinal()) {
            case 2 -> Direction.UP;
            case 1 -> Direction.DOWN;
            case 3 -> current.getClockWise();
            case 6 -> current.getOpposite();
            case 4 -> current.getCounterClockWise();
            default -> current;
        };
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getTextureX(boolean toggled) {
        return this.ordinal() * 32 + (toggled ? 16 : 0);
    }

    public int getTextureY() {
        return 48;
    }

    public String getSerializedName() {
        return this.name;
    }

    @Override
    public String getTranslationKey() {
        return "modularrouters.guiText.tooltip.relative_dir." + this.name;
    }
}

