/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import com.zeroregard.ars_technica.Config;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidHelper {
    public static int BLOCK_MAX_FLUID_LEVEL = 8;
    public static int FLUID_MB_MAX_IN_BLOCK = 1000;
    public static int FLUID_TO_MB_MULTIPLIER = FLUID_MB_MAX_IN_BLOCK / BLOCK_MAX_FLUID_LEVEL;

    public static void dumpFluid(FluidStack stack, Level world, Vec3 position, int expansion) {
        AtomicInteger remainingAmount = new AtomicInteger(stack.getAmount());
        AABB searchArea = new AABB(position.x - (double)expansion, position.y - (double)expansion, position.z - (double)expansion, position.x + (double)expansion, position.y + (double)expansion, position.z + (double)expansion);
        FluidHelper.getNearbyFluidTanks(world, searchArea, position).forEach(tank -> {
            int filled = tank.fill(new FluidStack(stack.getFluid(), Math.min(tank.getTankCapacity(0) - tank.getFluidInTank(0).getAmount(), remainingAmount.get())), IFluidHandler.FluidAction.EXECUTE);
            remainingAmount.addAndGet(-filled);
        });
        boolean canPlaceFluids = (Boolean)Config.Common.FLUID_CAN_BE_PLACED.get();
        if (!canPlaceFluids) {
            return;
        }
        boolean canPlaceSources = (Boolean)Config.Common.FLUID_SOURCES_CAN_BE_PLACED.get();
        int maxFluidsToPlace = (Integer)Config.Common.FLUID_MAX_PLACEMENTS_PER_FUSE.get();
        int fluidsPlaced = 0;
        if (remainingAmount.get() > 0) {
            List<BlockPos> airBlocks = FluidHelper.getNearbyAirBlocks(world, searchArea, position);
            for (int i = 0; i < airBlocks.size(); ++i) {
                BlockPos airPos = airBlocks.get(i);
                if (remainingAmount.get() <= 0 || fluidsPlaced >= maxFluidsToPlace) break;
                if (!world.getBlockState(airPos).isAir()) continue;
                int amountToPlace = Math.min(remainingAmount.get(), FLUID_MB_MAX_IN_BLOCK);
                int blockStateAmount = amountToPlace / FLUID_TO_MB_MULTIPLIER;
                boolean shouldPlaceSource = amountToPlace == FLUID_MB_MAX_IN_BLOCK;
                Fluid fluid = canPlaceSources && shouldPlaceSource ? com.simibubi.create.foundation.fluid.FluidHelper.convertToStill((Fluid)stack.getFluid()) : stack.getFluid();
                BlockState fluidBlockState = fluid.defaultFluidState().createLegacyBlock();
                if (!shouldPlaceSource && fluidBlockState.hasProperty((Property)BlockStateProperties.LEVEL)) {
                    fluidBlockState = (BlockState)fluidBlockState.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(blockStateAmount));
                }
                world.setBlock(airPos, fluidBlockState, 18);
                ++fluidsPlaced;
                remainingAmount.addAndGet(-amountToPlace);
            }
        }
    }

    private static Stream<IFluidHandler> getNearbyFluidTanks(Level world, AABB searchArea, Vec3 position) {
        ArrayList handlers = new ArrayList();
        BlockPos.betweenClosedStream((AABB)searchArea).forEach(pos -> {
            BlockEntity be = world.getBlockEntity(pos);
            IFluidHandler handler = FluidHelper.getHandlerFromCap(pos, world, 0);
            if (be != null && handler != null && (handler.getFluidInTank(0).isEmpty() || handler.getFluidInTank(0).getAmount() <= handler.getTankCapacity(0) - FLUID_MB_MAX_IN_BLOCK)) {
                handlers.add(handler);
            }
        });
        return handlers.stream();
    }

    private static List<BlockPos> getNearbyAirBlocks(Level world, AABB searchArea, Vec3 position) {
        ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
        int minX = (int)searchArea.minX;
        int maxX = (int)searchArea.maxX;
        int minY = (int)searchArea.minY;
        int maxY = (int)searchArea.maxY;
        int minZ = (int)searchArea.minZ;
        int maxZ = (int)searchArea.maxZ;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    Block block = world.getBlockState(currentPos).getBlock();
                    if (block != Blocks.AIR) continue;
                    airBlocks.add(currentPos);
                }
            }
        }
        airBlocks.sort(Comparator.comparingDouble(pos -> position.distanceToSqr(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()))));
        return airBlocks;
    }

    @Nullable
    public static IFluidHandler getHandlerFromCap(BlockPos pos, Level level, int sideOrdinal) {
        BlockEntity be = level.getBlockEntity(pos);
        Direction side = sideOrdinal < 0 ? null : Direction.values()[sideOrdinal];
        return (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(level, pos, null, be, (Object)side);
    }
}

