/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.zeroregard.ars_technica.client.entity.ArcaneWhirlModel;
import com.zeroregard.ars_technica.client.entity.GenericRenderer;
import com.zeroregard.ars_technica.entity.ArcaneWhirlEntity;
import com.zeroregard.ars_technica.glyphs.EffectWhirl;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ArcaneWhirlEntityRenderer
extends GenericRenderer<ArcaneWhirlEntity> {
    private final ArcaneWhirlModel model = (ArcaneWhirlModel)this.getGeoModel();

    public ArcaneWhirlEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new ArcaneWhirlModel());
    }

    public void render(ArcaneWhirlEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        FanProcessingType type = entity.getProcessor();
        this.model.setType(type);
        float scale = this.getScaleFromRadius(entity);
        matrixStack.pushPose();
        matrixStack.scale(scale, scale, scale);
        super.render((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.popPose();
    }

    private float getScaleFromRadius(ArcaneWhirlEntity entity) {
        return entity.getRadius() / EffectWhirl.INSTANCE.DEFAULT_RADIUS;
    }

    public ResourceLocation getTextureLocation(ArcaneWhirlEntity entity) {
        return this.model.getTextureResource(entity);
    }
}

