/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica;

import com.simibubi.create.api.stress.BlockStressValues;
import com.zeroregard.ars_technica.ArsNouveauRegistry;
import com.zeroregard.ars_technica.Config;
import com.zeroregard.ars_technica.network.ATPackets;
import com.zeroregard.ars_technica.registry.BlockRegistry;
import com.zeroregard.ars_technica.registry.GlyphRegistry;
import com.zeroregard.ars_technica.registry.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ars_technica")
public class ArsTechnica {
    public static final String MODID = "ars_technica";
    public static final Logger LOGGER = LogManager.getLogger();

    public ArsTechnica(IEventBus modEventBus, ModContainer modContainer) {
        ModRegistry.registerRegistries(modEventBus);
        ArsNouveauRegistry.init();
        GlyphRegistry.registerGlyphs();
        ATPackets.register();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation prefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private static void registerStressValues() {
        Block sourceMotorBlock = (Block)BlockRegistry.SOURCE_MOTOR.get();
        BlockStressValues.CAPACITIES.register((Object)sourceMotorBlock, () -> 256.0);
        BlockStressValues.setGeneratorSpeed((int)256).accept((Object)sourceMotorBlock);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ArsNouveauRegistry.postInit());
        ArsTechnica.registerStressValues();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }
}

