/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventGroups;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.neoforge.NativeEventListeners;
import dev.latvian.mods.kubejs.plugin.ClassFilter;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSFileWatcherThread;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.script.ScriptTypePredicate;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public enum ScriptType implements ScriptTypePredicate,
ScriptTypeHolder
{
    STARTUP("startup", "KubeJS Startup", KubeJSPaths.STARTUP_SCRIPTS),
    SERVER("server", "KubeJS Server", KubeJSPaths.SERVER_SCRIPTS),
    CLIENT("client", "KubeJS Client", KubeJSPaths.CLIENT_SCRIPTS);

    public static final ScriptType[] VALUES = ScriptType.values();
    public final String name;
    public final ConsoleJS console;
    public final Path path;
    public final String nameStrip;
    public transient Executor executor;
    public final Lazy<ClassFilter> classFilter;
    public final Map<NativeEventListeners.Key, NativeEventListeners> nativeEventListeners;
    public KubeJSFileWatcherThread fileWatcherThread;

    private ScriptType(String n2, String cname, Path path) {
        this.name = n2;
        this.console = new ConsoleJS(this, LoggerFactory.getLogger((String)cname));
        this.path = path;
        this.nameStrip = this.name + "_scripts:";
        this.executor = Runnable::run;
        this.classFilter = Lazy.of(() -> KubeJSPlugins.createClassFilter(this));
        this.nativeEventListeners = new HashMap<NativeEventListeners.Key, NativeEventListeners>(0);
    }

    public Path getLogFile() {
        Path dir = FMLPaths.GAMEDIR.get().resolve("logs/kubejs");
        Path file = dir.resolve(this.name + ".log");
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                Path oldFile = dir.resolve(this.name + ".txt");
                if (Files.exists(oldFile, new LinkOption[0])) {
                    Files.move(oldFile, file, new CopyOption[0]);
                } else {
                    Files.createFile(file, new FileAttribute[0]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return file;
    }

    public boolean isClient() {
        return this == CLIENT;
    }

    public boolean isServer() {
        return this == SERVER;
    }

    public boolean isStartup() {
        return this == STARTUP;
    }

    @HideFromJS
    public void unload() {
        this.console.resetFile();
        for (EventGroup group : EventGroups.ALL.get().map().values()) {
            for (EventHandler handler : group.getHandlers().values()) {
                handler.clear(this);
            }
        }
        for (NativeEventListeners listener : this.nativeEventListeners.values()) {
            listener.listeners.clear();
        }
        this.fileWatcherThread = null;
    }

    @Override
    public boolean test(ScriptType type) {
        return type == this;
    }

    @Override
    public List<ScriptType> getValidTypes() {
        return List.of(this);
    }

    @NotNull
    public ScriptTypePredicate negate() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ScriptTypePredicate.COMMON;
            case 1 -> ScriptTypePredicate.STARTUP_OR_CLIENT;
            case 2 -> ScriptTypePredicate.STARTUP_OR_SERVER;
        };
    }

    @Override
    public ScriptType kjs$getScriptType() {
        return this;
    }
}

