/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedLongValue;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public enum InductionCellTier implements ITier
{
    BASIC(BaseTier.BASIC, 8000000000L),
    ADVANCED(BaseTier.ADVANCED, 64000000000L),
    ELITE(BaseTier.ELITE, 512000000000L),
    ULTIMATE(BaseTier.ULTIMATE, 4000000000000L);

    private final long baseMaxEnergy;
    private final BaseTier baseTier;
    @Nullable
    private CachedLongValue storageReference;

    private InductionCellTier(BaseTier tier, long max) {
        this.baseMaxEnergy = max;
        this.baseTier = tier;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public long getMaxEnergy() {
        return this.storageReference == null ? this.getBaseMaxEnergy() : this.storageReference.getOrDefault();
    }

    public long getBaseMaxEnergy() {
        return this.baseMaxEnergy;
    }

    public void setConfigReference(CachedLongValue storageReference) {
        this.storageReference = storageReference;
    }
}

