/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.text;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.UnaryOperator;
import mekanism.api.functions.CharPredicate;
import mekanism.api.functions.CharUnaryOperator;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.ButtonType;
import mekanism.client.gui.element.text.IconType;
import mekanism.common.lib.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class GuiTextField
extends GuiElement {
    public static final int DEFAULT_BORDER_COLOR = -6250336;
    public static final int DEFAULT_BACKGROUND_COLOR = -16777216;
    public static final IntSupplier SCREEN_COLOR = SpecialColors.TEXT_SCREEN::argb;
    public static final IntSupplier DARK_SCREEN_COLOR = () -> Color.argb(SCREEN_COLOR.getAsInt()).darken(0.4).argb();
    private final ClearingEditBox textField;
    private ContainerEventHandler parent;
    private Runnable enterHandler;
    private CharPredicate inputValidator;
    private CharUnaryOperator inputTransformer;
    private UnaryOperator<String> pasteTransformer;
    private Consumer<String> responder;
    private BackgroundType backgroundType = BackgroundType.DEFAULT;
    private IconType iconType;
    private int textOffsetX;
    private int textOffsetY;
    private float textScale = 1.0f;
    private MekanismImageButton checkmarkButton;

    public GuiTextField(IGuiWrapper gui, int x, int y, int width, int height) {
        this(gui, gui, x, y, width, height);
    }

    public GuiTextField(IGuiWrapper gui, ContainerEventHandler parent, int x, int y, int width, int height) {
        super(gui, x, y, width, height);
        this.parent = parent;
        this.textField = new ClearingEditBox(this.font(), this.getX(), this.getY(), width, height, CommonComponents.EMPTY);
        this.textField.setBordered(false);
        this.textField.setResponder(s -> {
            if (this.responder != null) {
                this.responder.accept((String)s);
            }
            if (this.checkmarkButton != null) {
                this.checkmarkButton.active = !this.textField.getValue().isEmpty();
            }
        });
        this.updateTextField();
    }

    @Override
    public void transferToNewGui(IGuiWrapper gui) {
        boolean guiIsParent = this.parent == this.gui();
        super.transferToNewGui(gui);
        if (guiIsParent) {
            this.parent = gui;
        }
    }

    @Override
    public void resize(int prevLeft, int prevTop, int left, int top) {
        super.resize(prevLeft, prevTop, left, top);
        this.textField.setPosition(this.textField.getX() - prevLeft + left, this.textField.getY() - prevTop + top);
    }

    public GuiTextField setScale(float textScale) {
        this.textScale = textScale;
        return this;
    }

    public GuiTextField setOffset(int offsetX, int offsetY) {
        this.textOffsetX = offsetX;
        this.textOffsetY = offsetY;
        this.updateTextField();
        return this;
    }

    public GuiTextField configureDigitalInput(Runnable enterHandler) {
        this.setBackground(BackgroundType.NONE);
        this.setIcon(IconType.DIGITAL);
        this.setTextColor(this.screenTextColor());
        this.setEnterHandler(enterHandler);
        this.addCheckmarkButton(ButtonType.DIGITAL, enterHandler);
        this.setScale(0.8f);
        return this;
    }

    public GuiTextField configureDigitalBorderInput(Runnable enterHandler) {
        this.setBackground(BackgroundType.DIGITAL);
        this.setTextColor(this.screenTextColor());
        this.setEnterHandler(enterHandler);
        this.addCheckmarkButton(ButtonType.DIGITAL, enterHandler);
        this.setScale(0.8f);
        return this;
    }

    public GuiTextField setEnterHandler(Runnable enterHandler) {
        this.enterHandler = enterHandler;
        return this;
    }

    public GuiTextField setInputValidator(CharPredicate inputValidator) {
        this.inputValidator = inputValidator;
        return this;
    }

    public GuiTextField setInputTransformer(CharUnaryOperator inputTransformer) {
        this.inputTransformer = inputTransformer;
        return this;
    }

    public GuiTextField setPasteTransformer(UnaryOperator<String> pasteTransformer) {
        this.pasteTransformer = pasteTransformer;
        return this;
    }

    public GuiTextField setBackground(BackgroundType backgroundType) {
        this.backgroundType = backgroundType;
        this.textField.setBordered(backgroundType == BackgroundType.DEFAULT);
        return this;
    }

    public GuiTextField setIcon(IconType iconType) {
        this.iconType = iconType;
        this.updateTextField();
        return this;
    }

    public GuiTextField addCheckmarkButton(Runnable callback) {
        return this.addCheckmarkButton(ButtonType.NORMAL, callback);
    }

    public GuiTextField addCheckmarkButton(ButtonType type, Runnable callback) {
        this.checkmarkButton = this.addChild(type.getButton(this, (element, mouseX, mouseY) -> {
            callback.run();
            this.parent.setFocused((GuiEventListener)this);
            return true;
        }));
        this.checkmarkButton.active = false;
        this.updateTextField();
        return this;
    }

    private void updateTextField() {
        int iconOffsetX = this.iconType == null ? 0 : this.iconType.getOffsetX();
        this.textField.setWidth(Math.round((float)(this.width - (this.checkmarkButton == null ? 0 : this.textField.getHeight() + 2) - iconOffsetX) / this.textScale));
        this.textField.setPosition(this.getX() + this.textOffsetX + 2 + iconOffsetX, this.getY() + this.textOffsetY + 1 + (int)((float)this.height / 2.0f - 4.0f));
    }

    public boolean isTextFieldFocused() {
        return this.textField.isFocused();
    }

    @Override
    public void move(int changeX, int changeY) {
        super.move(changeX, changeY);
        this.updateTextField();
    }

    protected boolean isValidClickButton(int button) {
        return super.isValidClickButton(button) || this.textField.isValidClickButton(button);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double scaledX = mouseX;
        if (this.textScale != 1.0f && scaledX > (double)this.textField.getX()) {
            scaledX = (double)this.textField.getX() + (scaledX - (double)this.textField.getX()) / (double)this.textScale;
        }
        if (this.textField.mouseClicked(scaledX, mouseY, button)) {
            return true;
        }
        return super.isValidClickButton(button) && super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.backgroundType.render(this, guiGraphics);
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)(-this.getGuiLeft()), (float)(-this.getGuiTop()), 0.0f);
        if (this.textScale == 1.0f) {
            this.textField.render(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            float reverse = (1.0f - this.textScale) / this.textScale;
            pose.scale(this.textScale, this.textScale, this.textScale);
            pose.translate((float)this.textField.getX() * reverse, (float)(this.textField.getY() + 4) * reverse, 0.0f);
            this.textField.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        pose.popPose();
        if (this.iconType != null) {
            guiGraphics.blit(this.iconType.getIcon(), this.relativeX + 2, this.relativeY + this.height / 2 - Mth.ceil((float)((float)this.iconType.getHeight() / 2.0f)), 0.0f, 0.0f, this.iconType.getWidth(), this.iconType.getHeight(), this.iconType.getWidth(), this.iconType.getHeight());
        }
    }

    @Override
    protected boolean supportsTabNavigation() {
        return true;
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        this.textField.setValue(((GuiTextField)element).getText());
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.canWrite()) {
            if (keyCode == 256 || keyCode == 258) {
                return false;
            }
            if (keyCode == 257 || keyCode == 335) {
                if (this.enterHandler != null) {
                    this.enterHandler.run();
                }
                return true;
            }
            if (Screen.isPaste((int)keyCode)) {
                String text = Minecraft.getInstance().keyboardHandler.getClipboard();
                if (this.pasteTransformer != null) {
                    text = (String)this.pasteTransformer.apply(text);
                }
                if (this.inputTransformer != null || this.inputValidator != null) {
                    boolean transformed = false;
                    char[] charArray = text.toCharArray();
                    for (int i = 0; i < charArray.length; ++i) {
                        char c = charArray[i];
                        if (this.inputTransformer != null) {
                            charArray[i] = c = this.inputTransformer.applyAsChar(c);
                            transformed = true;
                        }
                        if (this.inputValidator == null || this.inputValidator.test(c)) continue;
                        return false;
                    }
                    if (transformed) {
                        text = String.copyValueOf(charArray);
                    }
                }
                this.textField.insertText(text);
            } else {
                this.textField.keyPressed(keyCode, scanCode, modifiers);
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char c, int keyCode) {
        if (this.canWrite()) {
            if (this.inputTransformer != null) {
                c = this.inputTransformer.applyAsChar(c);
            }
            if (this.inputValidator == null || this.inputValidator.test(c)) {
                return this.textField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    public String getText() {
        return this.textField.getValue();
    }

    public void setVisible(boolean visible) {
        this.textField.setVisible(visible);
    }

    public void setMaxLength(int length) {
        this.textField.setMaxLength(length);
    }

    public void setTextColor(int color) {
        this.textField.setTextColor(color);
    }

    public void setTextColorUneditable(int color) {
        this.textField.setTextColorUneditable(color);
    }

    public void setEditable(boolean enabled) {
        this.textField.setEditable(enabled);
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.textField.setCanLoseFocus(canLoseFocus);
    }

    public void allowColoredText() {
        this.textField.allowColors = true;
    }

    public void setFocused(boolean focused) {
        if (this.textField.canLoseFocus || focused) {
            super.setFocused(focused);
            this.textField.setFocused(focused);
        }
    }

    public boolean canWrite() {
        return this.textField.canConsumeInput();
    }

    public void setText(String text) {
        this.textField.setValue(text);
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }

    private static class ClearingEditBox
    extends EditBox {
        private boolean allowColors;

        public ClearingEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
        }

        public boolean isValidClickButton(int button) {
            return super.isValidClickButton(button) || button == 1;
        }

        public void onClick(double mouseX, double mouseY, int button) {
            if (button == 1) {
                this.setValue("");
            } else {
                super.onClick(mouseX, mouseY, button);
            }
        }

        public void insertText(@NotNull String text) {
            if (this.allowColors) {
                int startIndex = Math.min(this.getCursorPosition(), this.highlightPos);
                int highlightEndIndex = Math.max(this.getCursorPosition(), this.highlightPos);
                String value = this.getValue();
                int spaceLeft = this.maxLength - value.length() - (startIndex - highlightEndIndex);
                if (spaceLeft > 0) {
                    String filtered = ClearingEditBox.filterText(text);
                    int length = filtered.length();
                    if (spaceLeft < length) {
                        if (Character.isHighSurrogate(filtered.charAt(spaceLeft - 1))) {
                            --spaceLeft;
                        }
                        filtered = filtered.substring(0, spaceLeft);
                        length = spaceLeft;
                    }
                    this.setValue(new StringBuilder(value).replace(startIndex, highlightEndIndex, filtered).toString());
                    this.setCursorPosition(startIndex + length);
                    this.setHighlightPos(this.getCursorPosition());
                }
            } else {
                super.insertText(text);
            }
        }

        private static String filterText(String text) {
            StringBuilder builder = new StringBuilder();
            for (char c : text.toCharArray()) {
                if (!StringUtil.isAllowedChatCharacter((char)c) && c != '\u00a7') continue;
                builder.append(c);
            }
            return builder.toString();
        }
    }
}

