/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.warning.IWarningTracker;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiWarningTab
extends GuiTexturedElement {
    private static final ResourceLocation WARNING_LEFT = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "warning_info_left.png");
    private static final ResourceLocation WARNING_RIGHT = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "warning_info_right.png");
    private final IWarningTracker warningTracker;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;

    public GuiWarningTab(IGuiWrapper gui, IWarningTracker warningTracker, boolean left) {
        super(left ? WARNING_LEFT : WARNING_RIGHT, gui, left ? -26 : gui.getXSize(), 109, 26, 26);
        this.warningTracker = warningTracker;
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.visible = this.warningTracker.hasWarning();
    }

    @Override
    public void tick() {
        super.tick();
        this.updateVisibility();
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(this.getResource(), this.relativeX, this.relativeY, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        ArrayList<Component> info = new ArrayList<Component>();
        info.add((Component)MekanismLang.ISSUES.translateColored(EnumColor.YELLOW));
        info.addAll(this.warningTracker.getWarnings());
        if (!info.equals(this.lastInfo)) {
            this.lastInfo = info;
            this.lastTooltip = TooltipUtils.create(info);
        }
        this.setTooltip(this.lastTooltip);
    }
}

