/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.ISidedChemicalHandler;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IMekanismChemicalHandler
extends ISidedChemicalHandler,
IContentsListener {
    default public boolean canHandleChemicals() {
        return true;
    }

    public List<IChemicalTank> getChemicalTanks(@Nullable Direction var1);

    @Nullable
    default public IChemicalTank getChemicalTank(int tank, @Nullable Direction side) {
        List<IChemicalTank> tanks = this.getChemicalTanks(side);
        return tank >= 0 && tank < tanks.size() ? tanks.get(tank) : null;
    }

    @Override
    default public int getCountChemicalTanks(@Nullable Direction side) {
        return this.getChemicalTanks(side).size();
    }

    @Override
    default public ChemicalStack getChemicalInTank(int tank, @Nullable Direction side) {
        IChemicalTank chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank == null ? ChemicalStack.EMPTY : chemicalTank.getStack();
    }

    @Override
    default public void setChemicalInTank(int tank, ChemicalStack stack, @Nullable Direction side) {
        IChemicalTank chemicalTank = this.getChemicalTank(tank, side);
        if (chemicalTank != null) {
            chemicalTank.setStack(stack);
        }
    }

    @Override
    default public long getChemicalTankCapacity(int tank, @Nullable Direction side) {
        IChemicalTank chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank == null ? 0L : chemicalTank.getCapacity();
    }

    @Override
    default public boolean isValid(int tank, ChemicalStack stack, @Nullable Direction side) {
        IChemicalTank chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank != null && chemicalTank.isValid(stack);
    }

    @Override
    default public ChemicalStack insertChemical(int tank, ChemicalStack stack, @Nullable Direction side, Action action) {
        IChemicalTank chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank == null ? stack : chemicalTank.insert(stack, action, AutomationType.handler(side));
    }

    @Override
    default public ChemicalStack extractChemical(int tank, long amount, @Nullable Direction side, Action action) {
        IChemicalTank chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank == null ? ChemicalStack.EMPTY : chemicalTank.extract(amount, action, AutomationType.handler(side));
    }

    @Override
    default public ChemicalStack insertChemical(ChemicalStack stack, @Nullable Direction side, Action action) {
        return ChemicalUtils.insert(stack, side, this::getChemicalTanks, action, AutomationType.handler(side));
    }

    @Override
    default public ChemicalStack extractChemical(long amount, @Nullable Direction side, Action action) {
        return ChemicalUtils.extract(amount, side, this::getChemicalTanks, action, AutomationType.handler(side));
    }

    @Override
    default public ChemicalStack extractChemical(ChemicalStack stack, @Nullable Direction side, Action action) {
        return ChemicalUtils.extract(stack, side, this::getChemicalTanks, action, AutomationType.handler(side));
    }
}

