/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.serialization;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.runtime.SwitchBootstraps;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class TomlOps
implements DynamicOps<Object> {
    public static final TomlOps INSTANCE = new TomlOps();

    private TomlOps() {
    }

    public Object empty() {
        return NullObject.NULL_OBJECT;
    }

    public <U> U convertTo(DynamicOps<U> outOps, Object input) {
        Object object = input;
        int n = 0;
        return (U)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Config.class, Collection.class, NullObject.class, Enum.class, Temporal.class, String.class, Boolean.class, Number.class}, (Object)object, n)) {
            case 0 -> {
                Config __ = (Config)object;
                yield this.convertMap(outOps, input);
            }
            case 1 -> {
                Collection __ = (Collection)object;
                yield this.convertList(outOps, input);
            }
            case -1 -> outOps.empty();
            case 2 -> {
                NullObject __ = (NullObject)object;
                yield outOps.empty();
            }
            case 3 -> {
                Enum inputEnum = (Enum)object;
                yield outOps.createString(inputEnum.name());
            }
            case 4 -> {
                Temporal __ = (Temporal)object;
                yield outOps.createString(input.toString());
            }
            case 5 -> {
                String string = (String)object;
                yield outOps.createString(string);
            }
            case 6 -> {
                Boolean bool = (Boolean)object;
                yield outOps.createBoolean(bool.booleanValue());
            }
            case 7 -> {
                Number number = (Number)object;
                yield outOps.createNumeric(number);
            }
            default -> throw new UnsupportedOperationException("TomlConfigOps was unable to convert toml value: " + String.valueOf(input));
        });
    }

    public DataResult<Number> getNumberValue(Object input) {
        DataResult dataResult;
        if (input instanceof Number) {
            Number number = (Number)input;
            dataResult = DataResult.success((Object)number);
        } else {
            dataResult = DataResult.error(() -> "Not a number: " + String.valueOf(input));
        }
        return dataResult;
    }

    public DataResult<Boolean> getBooleanValue(Object input) {
        if (input instanceof Boolean) {
            Boolean bool = (Boolean)input;
            return DataResult.success((Object)bool);
        }
        if (input instanceof Number) {
            Number number = (Number)input;
            return DataResult.success((Object)(number.intValue() > 0 ? 1 : 0));
        }
        return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
    }

    public Object createBoolean(boolean value) {
        return value;
    }

    public Object createNumeric(Number i) {
        return i;
    }

    public DataResult<String> getStringValue(Object input) {
        if (input instanceof Config || input instanceof Collection) {
            return DataResult.error(() -> "Not a string: " + String.valueOf(input));
        }
        return DataResult.success((Object)String.valueOf(input));
    }

    public Object createString(String value) {
        return value;
    }

    public DataResult<Object> mergeToList(Object list, List<Object> values) {
        return super.mergeToList(list, values).map(obj -> obj == this.empty() ? Lists.newArrayList() : obj);
    }

    public DataResult<Object> mergeToList(Object list, Object value) {
        if (!(list instanceof Collection) && list != this.empty()) {
            return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
        }
        ArrayList result = Lists.newArrayList();
        if (list != this.empty()) {
            Collection listAsCollection = (Collection)list;
            result.addAll(listAsCollection);
        }
        result.add(value);
        return DataResult.success((Object)result);
    }

    public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
        if (!(map instanceof Config) && map != this.empty()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        DataResult<String> stringResult = this.getStringValue(key);
        Optional badResult = stringResult.error();
        if (badResult.isPresent()) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
        }
        return stringResult.flatMap(s -> {
            CommentedConfig output = TomlFormat.newConfig();
            if (map != this.empty()) {
                Config oldConfig = (Config)map;
                output.addAll((UnmodifiableConfig)oldConfig);
            }
            output.add(s, value);
            return DataResult.success((Object)output);
        });
    }

    public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
        if (!(input instanceof Config)) {
            return DataResult.error(() -> "Not a Config: " + String.valueOf(input));
        }
        Config config = (Config)input;
        return DataResult.success(config.entrySet().stream().map(entry -> Pair.of((Object)entry.getKey(), (Object)entry.getValue())));
    }

    public Object createMap(Stream<Pair<Object, Object>> map) {
        CommentedConfig result = TomlFormat.newConfig();
        map.forEach(arg_0 -> this.lambda$createMap$10((Config)result, arg_0));
        return result;
    }

    public DataResult<Stream<Object>> getStream(Object input) {
        if (input instanceof Collection) {
            Collection collection = (Collection)input;
            return DataResult.success(collection.stream());
        }
        return DataResult.error(() -> "Not a collection: " + String.valueOf(input));
    }

    public Object createList(Stream<Object> input) {
        return input.toList();
    }

    public Object remove(Object input, String key) {
        if (input instanceof Config) {
            Config oldConfig = (Config)input;
            CommentedConfig result = TomlFormat.newConfig();
            oldConfig.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(arg_0 -> TomlOps.lambda$remove$13((Config)result, arg_0));
            return result;
        }
        return input;
    }

    public String toString() {
        return "TOML";
    }

    private static /* synthetic */ void lambda$remove$13(Config result, Config.Entry entry) {
        result.add(entry.getKey(), entry.getValue());
    }

    private /* synthetic */ void lambda$createMap$10(Config result, Pair p) {
        result.add((String)this.getStringValue(p.getFirst()).getOrThrow(), p.getSecond());
    }
}

