/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import twilightforest.entity.passive.Raven;
import twilightforest.init.TFEntities;
import twilightforest.util.features.FeatureUtil;

public class MonolithFeature
extends Feature<NoneFeatureConfiguration> {
    public MonolithFeature(Codec<NoneFeatureConfiguration> configIn) {
        super(configIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        int cy;
        int h2;
        int h1;
        int h0;
        WorldGenLevel world = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource rand = ctx.random();
        int ht = rand.nextInt(10) + 10;
        int dir = rand.nextInt(4);
        if (!FeatureUtil.isAreaSuitable(world, pos, 2, ht, 2)) {
            return false;
        }
        int h3 = switch (dir) {
            case 0 -> {
                h0 = ht;
                h1 = (int)((double)ht * 0.75);
                h2 = (int)((double)ht * 0.75);
                yield (int)((double)ht * 0.5);
            }
            case 1 -> {
                h0 = (int)((double)ht * 0.5);
                h1 = ht;
                h2 = (int)((double)ht * 0.75);
                yield (int)((double)ht * 0.75);
            }
            case 2 -> {
                h0 = (int)((double)ht * 0.75);
                h1 = (int)((double)ht * 0.5);
                h2 = ht;
                yield (int)((double)ht * 0.75);
            }
            default -> {
                h0 = (int)((double)ht * 0.75);
                h1 = (int)((double)ht * 0.75);
                h2 = (int)((double)ht * 0.5);
                yield ht;
            }
        };
        for (cy = 0; cy <= h0; ++cy) {
            world.setBlock(pos.offset(0, cy - 1, 0), cy == ht ? Blocks.LAPIS_BLOCK.defaultBlockState() : Blocks.OBSIDIAN.defaultBlockState(), 3);
        }
        for (cy = 0; cy <= h1; ++cy) {
            world.setBlock(pos.offset(1, cy - 1, 0), cy == ht ? Blocks.LAPIS_BLOCK.defaultBlockState() : Blocks.OBSIDIAN.defaultBlockState(), 3);
        }
        for (cy = 0; cy <= h2; ++cy) {
            world.setBlock(pos.offset(0, cy - 1, 1), cy == ht ? Blocks.LAPIS_BLOCK.defaultBlockState() : Blocks.OBSIDIAN.defaultBlockState(), 3);
        }
        for (cy = 0; cy <= h3; ++cy) {
            world.setBlock(pos.offset(1, cy - 1, 1), cy == ht ? Blocks.LAPIS_BLOCK.defaultBlockState() : Blocks.OBSIDIAN.defaultBlockState(), 3);
        }
        for (int i = 0; i < 2; ++i) {
            BlockPos dPos = pos.offset(rand.nextInt(8) - rand.nextInt(8), 0, rand.nextInt(8) - rand.nextInt(8));
            if ((dPos = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dPos)).getY() <= 0) continue;
            Raven raven = (Raven)((EntityType)TFEntities.RAVEN.get()).create((Level)world.getLevel());
            raven.moveTo(dPos, rand.nextFloat() * 360.0f, 0.0f);
            world.addFreshEntity((Entity)raven);
        }
        return true;
    }
}

