/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import twilightforest.block.HugeLilyPadBlock;
import twilightforest.enums.HugeLilypadPiece;
import twilightforest.init.TFBlocks;

public class HugeLilypadFeature
extends Feature<NoneFeatureConfiguration> {
    public HugeLilypadFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel world = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource random = ctx.random();
        for (int i = 0; i < 10; ++i) {
            BlockPos dPos = pos.offset(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!this.shouldPlacePadAt((LevelAccessor)world, dPos) || !world.isAreaLoaded(dPos, 1)) continue;
            Direction horizontal = Direction.from2DDataValue((int)random.nextInt(4));
            BlockState lilypad = (BlockState)((HugeLilyPadBlock)((Object)TFBlocks.HUGE_LILY_PAD.get())).defaultBlockState().setValue((Property)HugeLilyPadBlock.FACING, (Comparable)horizontal);
            world.setBlock(dPos, (BlockState)lilypad.setValue(HugeLilyPadBlock.PIECE, (Comparable)((Object)HugeLilypadPiece.NW)), 18);
            world.setBlock(dPos.east(), (BlockState)lilypad.setValue(HugeLilyPadBlock.PIECE, (Comparable)((Object)HugeLilypadPiece.NE)), 18);
            world.setBlock(dPos.east().south(), (BlockState)lilypad.setValue(HugeLilyPadBlock.PIECE, (Comparable)((Object)HugeLilypadPiece.SE)), 18);
            world.setBlock(dPos.south(), (BlockState)lilypad.setValue(HugeLilyPadBlock.PIECE, (Comparable)((Object)HugeLilypadPiece.SW)), 18);
        }
        return true;
    }

    private boolean shouldPlacePadAt(LevelAccessor world, BlockPos pos) {
        return world.isEmptyBlock(pos) && world.getBlockState(pos.below()).is(Blocks.WATER) && world.isEmptyBlock(pos.east()) && world.getBlockState(pos.east().below()).is(Blocks.WATER) && world.isEmptyBlock(pos.south()) && world.getBlockState(pos.south().below()).is(Blocks.WATER) && world.isEmptyBlock(pos.east().south()) && world.getBlockState(pos.east().south().below()).is(Blocks.WATER);
    }
}

