/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public abstract class AbsoluteDifferenceFunction
implements DensityFunction.SimpleFunction {
    protected final double max;
    protected final double centerX;
    protected final double centerZ;

    public static Min min(double max, BlockPos pos) {
        return new Min(max, pos.getX(), pos.getZ());
    }

    public static Max max(double max, BlockPos pos) {
        return new Max(max, pos.getX(), pos.getZ());
    }

    public AbsoluteDifferenceFunction(double max, double centerX, double centerZ) {
        this.max = max;
        this.centerX = centerX;
        this.centerZ = centerZ;
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return this.max;
    }

    public static class Min
    extends AbsoluteDifferenceFunction {
        public static final MapCodec<Min> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("max").forGetter(f -> f.max), (App)Codec.DOUBLE.fieldOf("x_center").forGetter(f -> f.centerX), (App)Codec.DOUBLE.fieldOf("z_center").forGetter(f -> f.centerZ)).apply((Applicative)instance, Min::new));
        public static final KeyDispatchDataCodec<Min> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);

        public Min(double max, double xCenter, double zCenter) {
            super(max, xCenter, zCenter);
        }

        public double compute(DensityFunction.FunctionContext context) {
            return Math.min(Math.min(Math.abs((double)context.blockX() - this.centerX), Math.abs((double)context.blockZ() - this.centerZ)), this.max);
        }

        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return KEY_CODEC;
        }
    }

    public static class Max
    extends AbsoluteDifferenceFunction {
        public static final MapCodec<Max> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("max").forGetter(f -> f.max), (App)Codec.DOUBLE.fieldOf("x_center").forGetter(f -> f.centerX), (App)Codec.DOUBLE.fieldOf("z_center").forGetter(f -> f.centerZ)).apply((Applicative)instance, Max::new));
        public static final KeyDispatchDataCodec<Max> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);

        public Max(double max, double xCenter, double zCenter) {
            super(max, xCenter, zCenter);
        }

        public double compute(DensityFunction.FunctionContext context) {
            return Math.min(Math.max(Math.abs((double)context.blockX() - this.centerX), Math.abs((double)context.blockZ() - this.centerZ)), this.max);
        }

        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return KEY_CODEC;
        }
    }
}

