/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory.slot;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.CommonHooks;
import twilightforest.inventory.UncraftingContainer;
import twilightforest.inventory.UncraftingMenu;

public class UncraftingResultSlot
extends ResultSlot {
    private final Player player;
    private final Container inputSlot;
    private final UncraftingContainer uncraftingMatrix;
    private final CraftingContainer assemblyMatrix;
    private final Map<Integer, ItemStack> tempRemainderMap;

    public UncraftingResultSlot(Player player, Container input, Container uncraftingMatrix, Container assemblyMatrix, Container result, int slotIndex, int x, int y) {
        super(player, (CraftingContainer)assemblyMatrix, result, slotIndex, x, y);
        this.player = player;
        this.inputSlot = input;
        this.uncraftingMatrix = (UncraftingContainer)uncraftingMatrix;
        this.assemblyMatrix = (CraftingContainer)assemblyMatrix;
        this.tempRemainderMap = new HashMap<Integer, ItemStack>();
    }

    public void onTake(Player player, ItemStack stack) {
        boolean combined = true;
        this.tempRemainderMap.clear();
        for (RecipeHolder recipe : player.level().getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)this.assemblyMatrix.asCraftInput(), this.player.level())) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)player.level().registryAccess()), (ItemStack)stack)) continue;
            combined = false;
            break;
        }
        if (combined) {
            if (this.uncraftingMatrix.recraftingCost > 0) {
                this.player.giveExperienceLevels(-this.uncraftingMatrix.recraftingCost);
            }
            for (int i = 0; i < this.uncraftingMatrix.getContainerSize(); ++i) {
                if (!this.assemblyMatrix.getItem(i).isEmpty()) continue;
                if (!UncraftingMenu.isMarked(this.uncraftingMatrix.getItem(i))) {
                    this.uncraftingMatrix.setItem(i, ItemStack.EMPTY);
                    continue;
                }
                this.tempRemainderMap.put(i, this.uncraftingMatrix.getItem(i));
            }
            this.inputSlot.removeItem(0, this.uncraftingMatrix.numberOfInputItems);
        }
        this.checkTakeAchievements(stack);
        CraftingInput.Positioned positioned = this.assemblyMatrix.asPositionedCraftInput();
        CraftingInput input = positioned.input();
        int i = positioned.left();
        int j = positioned.top();
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList remainingItems = player.level().getRecipeManager().getRemainingItemsFor(RecipeType.CRAFTING, (RecipeInput)input, player.level());
        CommonHooks.setCraftingPlayer(null);
        for (int k = 0; k < input.height(); ++k) {
            for (int l = 0; l < input.width(); ++l) {
                int index = l + i + (k + j) * this.assemblyMatrix.getWidth();
                ItemStack currentStack = this.assemblyMatrix.getItem(index);
                ItemStack remainingStack = (ItemStack)remainingItems.get(l + k * input.width());
                if (!currentStack.isEmpty()) {
                    this.assemblyMatrix.removeItem(index, 1);
                    currentStack = this.assemblyMatrix.getItem(index);
                }
                if (remainingStack.isEmpty()) continue;
                if (currentStack.isEmpty()) {
                    this.assemblyMatrix.setItem(index, remainingStack);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)remainingStack) || this.player.getInventory().add(remainingStack)) continue;
                this.player.drop(remainingStack, false);
            }
        }
        if (!this.tempRemainderMap.isEmpty()) {
            this.tempRemainderMap.forEach((arg_0, arg_1) -> ((CraftingContainer)this.assemblyMatrix).setItem(arg_0, arg_1));
        }
    }
}

