/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.enchantment.ApplyFrostedEffect;
import twilightforest.entity.boss.AlphaYeti;
import twilightforest.entity.monster.Yeti;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;

public class IceBomb
extends TFThrowable {
    private int zoneTimer = 101;
    private boolean hasHit;

    public IceBomb(EntityType<? extends IceBomb> type, Level level) {
        super(type, level);
    }

    public IceBomb(EntityType<? extends IceBomb> type, Level level, LivingEntity thrower) {
        super(type, level, thrower);
    }

    public IceBomb(Level level, Position pos) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.THROWN_ICE.get()), level, pos.x(), pos.y(), pos.z());
    }

    protected void onHitBlock(BlockHitResult result) {
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.hasHit = true;
        this.doTerrainEffects(2);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity entity = pResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.inflictDamage(entity2, 2);
        }
    }

    private void doTerrainEffects(int range) {
        int ix = Mth.floor((double)this.xOld);
        int iy = Mth.floor((double)this.yOld);
        int iz = Mth.floor((double)this.zOld);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == range && Math.abs(z) == range) continue;
                for (int y = -range; y <= range; ++y) {
                    BlockPos pos = new BlockPos(ix + x, iy + y, iz + z);
                    this.doTerrainEffect(pos);
                }
            }
        }
    }

    private void doTerrainEffect(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos);
        if (!this.level().isClientSide()) {
            if (state.is(Blocks.WATER)) {
                this.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
            }
            if (state == Blocks.LAVA.defaultBlockState()) {
                this.level().setBlockAndUpdate(pos, Blocks.OBSIDIAN.defaultBlockState());
            }
            if (this.level().isEmptyBlock(pos) && Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)this.level(), pos)) {
                this.level().setBlockAndUpdate(pos, Blocks.SNOW.defaultBlockState());
            }
            if (state.is(BlockTagGenerator.ICE_BOMB_REPLACEABLES)) {
                this.level().setBlock(pos, Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)this.level(), pos) ? Blocks.SNOW.defaultBlockState() : Blocks.AIR.defaultBlockState(), 3);
            }
            if (state.is(Blocks.SNOW) && (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) < 8) {
                this.level().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)SnowLayerBlock.LAYERS) + 1)));
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.hasHit) {
            this.getDeltaMovement().multiply(0.1, 0.1, 0.1);
            --this.zoneTimer;
            this.makeIceZone();
            if (!this.level().isClientSide() && this.zoneTimer <= 0) {
                this.level().levelEvent(2001, new BlockPos((Vec3i)this.blockPosition()), Block.getId((BlockState)Blocks.ICE.defaultBlockState()));
                this.discard();
            }
        } else {
            this.makeTrail((ParticleOptions)TFParticleType.SNOW_GUARDIAN.get(), this.getOwner() instanceof AlphaYeti ? 2 : 5);
        }
    }

    @Override
    public void makeTrail(ParticleOptions particle, double r, double g, double b, int amount) {
        for (int i = 0; i < amount; ++i) {
            double dx = this.getX() + 0.5 * (this.random.nextDouble() - this.random.nextDouble());
            double dy = this.getY() + 0.5 * (this.random.nextDouble() - this.random.nextDouble()) + 0.5;
            double dz = this.getZ() + 0.5 * (this.random.nextDouble() - this.random.nextDouble());
            this.level().addParticle(particle, dx, dy, dz, r, g, b);
        }
    }

    private void makeIceZone() {
        if (this.level().isClientSide()) {
            for (int i = 0; i < 16; ++i) {
                double dx = this.getX() + (double)((this.random.nextFloat() - this.random.nextFloat()) * 3.5f);
                double dy = this.getY() + (double)((this.random.nextFloat() - this.random.nextFloat()) * 3.5f);
                double dz = this.getZ() + (double)((this.random.nextFloat() - this.random.nextFloat()) * 3.5f);
                this.level().addParticle((ParticleOptions)TFParticleType.SNOW_GUARDIAN.get(), dx, dy, dz, 0.0, 0.0, 0.0);
            }
        } else {
            if (this.zoneTimer == 99) {
                this.doTerrainEffects(3);
            }
            if (this.zoneTimer % 20 == 0) {
                this.hitNearbyEntities();
            }
        }
    }

    private void hitNearbyEntities() {
        List nearby = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0, 2.0, 3.0));
        for (LivingEntity entity : nearby) {
            if (entity == this.getOwner()) continue;
            if (entity instanceof Yeti) {
                BlockPos pos = BlockPos.containing((double)entity.xOld, (double)entity.yOld, (double)entity.zOld);
                this.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                this.level().setBlockAndUpdate(pos.above(), Blocks.ICE.defaultBlockState());
                entity.discard();
                continue;
            }
            this.inflictDamage(entity, 1);
        }
    }

    private void inflictDamage(LivingEntity entity, int dmgMultiplier) {
        if (!entity.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES)) {
            entity.hurt(TFDamageTypes.getIndirectEntityDamageSource(this.level(), TFDamageTypes.FROZEN, (Entity)this, this.getOwner(), new EntityType[0]), (entity.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES) ? 5.0f : 1.0f) * (float)dmgMultiplier);
            ApplyFrostedEffect.doChillAuraEffect(entity, 100 * dmgMultiplier, 0, true);
        }
    }

    public BlockState getBlockState() {
        return Blocks.PACKED_ICE.defaultBlockState();
    }

    protected double getDefaultGravity() {
        return this.hasHit ? 0.0 : (double)0.025f;
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putInt("zone_timer", this.zoneTimer);
        pCompound.putBoolean("has_hit", this.hasHit);
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        this.zoneTimer = pCompound.getInt("zone_timer");
        this.hasHit = pCompound.getBoolean("has_hit");
    }
}

