/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.entity.monster.BaseIceMob;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;
import twilightforest.util.ColorUtil;

public class UnstableIceCore
extends BaseIceMob {
    private static final float EXPLOSION_RADIUS = 1.0f;

    public UnstableIceCore(EntityType<? extends UnstableIceCore> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.ICE_CORE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.ICE_CORE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.ICE_CORE_DEATH.get();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 60) {
            if (!this.level().isClientSide()) {
                boolean mobGriefing = EventHooks.canEntityGrief((Level)this.level(), (Entity)this);
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, Level.ExplosionInteraction.MOB);
                if (mobGriefing) {
                    this.transformBlocks();
                }
            }
            this.deathTime = 19;
            super.tickDeath();
            this.deathTime = 60;
        }
    }

    private void transformBlocks() {
        int range = 4;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    float randRange;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (!(distance < (double)(randRange = (float)range + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 2.0f))) continue;
                    this.transformBlock(this.blockPosition().offset(dx, dy, dz));
                }
            }
        }
    }

    private void transformBlock(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos);
        Block block = state.getBlock();
        if (block.getExplosionResistance() < 8.0f && state.getDestroySpeed((BlockGetter)this.level(), pos) >= 0.0f) {
            int blockColor = state.getMapColor((BlockGetter)this.level(), (BlockPos)pos).col;
            if (this.shouldTransformGlass(state, pos)) {
                this.level().setBlockAndUpdate(pos, ColorUtil.STAINED_GLASS.getColor(UnstableIceCore.getClosestDyeColor(blockColor)));
            } else if (this.shouldTransformClay(state, pos)) {
                this.level().setBlockAndUpdate(pos, ColorUtil.TERRACOTTA.getColor(UnstableIceCore.getClosestDyeColor(blockColor)));
            }
        }
    }

    private boolean shouldTransformClay(BlockState state, BlockPos pos) {
        return !state.isAir() && state.isRedstoneConductor((BlockGetter)this.level(), pos);
    }

    private boolean shouldTransformGlass(BlockState state, BlockPos pos) {
        return !state.isAir() && this.isBlockNormalBounds(state, pos) && (!state.isSolid() || state.is(BlockTags.LEAVES) || state.is(Blocks.ICE) || state.is(TFBlocks.AURORA_BLOCK));
    }

    private boolean isBlockNormalBounds(BlockState state, BlockPos pos) {
        return Block.isShapeFullBlock((VoxelShape)state.getShape((BlockGetter)this.level(), pos));
    }

    private static DyeColor getClosestDyeColor(int blockColor) {
        int red = blockColor >> 16 & 0xFF;
        int green = blockColor >> 8 & 0xFF;
        int blue = blockColor & 0xFF;
        DyeColor bestColor = DyeColor.WHITE;
        int bestDifference = 1024;
        for (DyeColor color : DyeColor.values()) {
            int iColor = color.getTextureDiffuseColor();
            int iRed = FastColor.ARGB32.red((int)iColor);
            int iGreen = FastColor.ARGB32.green((int)iColor);
            int iBlue = FastColor.ARGB32.blue((int)iColor);
            int difference = Math.abs(red - iRed) + Math.abs(green - iGreen) + Math.abs(blue - iBlue);
            if (difference >= bestDifference) continue;
            bestColor = color;
            bestDifference = difference;
        }
        return bestColor;
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }
}

