/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import twilightforest.block.entity.OminousCandleBlockEntity;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFParticleType;

public class OminousCandleBlock
extends BaseEntityBlock {
    public static final MapCodec<OminousCandleBlock> CODEC = RecordCodecBuilder.mapCodec(app -> app.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("candle").forGetter(block -> block.candle), (App)OminousCandleBlock.propertiesCodec()).apply((Applicative)app, OminousCandleBlock::new));
    private static final VoxelShape ONE_AABB = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);
    private static final VoxelShape TWO_AABB = Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)6.0, (double)9.0);
    private static final VoxelShape THREE_AABB = Block.box((double)5.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)11.0);
    private static final VoxelShape FOUR_AABB = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)10.0);
    public static final IntegerProperty CANDLES = BlockStateProperties.CANDLES;
    public static final HashMap<Block, DeferredBlock<OminousCandleBlock>> CANDLE_MAP = (HashMap)Util.make(new HashMap(), map -> {
        map.put(Blocks.CANDLE, TFBlocks.OMINOUS_CANDLE);
        map.put(Blocks.WHITE_CANDLE, TFBlocks.OMINOUS_WHITE_CANDLE);
        map.put(Blocks.ORANGE_CANDLE, TFBlocks.OMINOUS_ORANGE_CANDLE);
        map.put(Blocks.MAGENTA_CANDLE, TFBlocks.OMINOUS_MAGENTA_CANDLE);
        map.put(Blocks.LIGHT_BLUE_CANDLE, TFBlocks.OMINOUS_LIGHT_BLUE_CANDLE);
        map.put(Blocks.YELLOW_CANDLE, TFBlocks.OMINOUS_YELLOW_CANDLE);
        map.put(Blocks.LIME_CANDLE, TFBlocks.OMINOUS_LIME_CANDLE);
        map.put(Blocks.PINK_CANDLE, TFBlocks.OMINOUS_PINK_CANDLE);
        map.put(Blocks.GRAY_CANDLE, TFBlocks.OMINOUS_GRAY_CANDLE);
        map.put(Blocks.LIGHT_GRAY_CANDLE, TFBlocks.OMINOUS_LIGHT_GRAY_CANDLE);
        map.put(Blocks.CYAN_CANDLE, TFBlocks.OMINOUS_CYAN_CANDLE);
        map.put(Blocks.PURPLE_CANDLE, TFBlocks.OMINOUS_PURPLE_CANDLE);
        map.put(Blocks.BLUE_CANDLE, TFBlocks.OMINOUS_BLUE_CANDLE);
        map.put(Blocks.BROWN_CANDLE, TFBlocks.OMINOUS_BROWN_CANDLE);
        map.put(Blocks.GREEN_CANDLE, TFBlocks.OMINOUS_GREEN_CANDLE);
        map.put(Blocks.RED_CANDLE, TFBlocks.OMINOUS_RED_CANDLE);
        map.put(Blocks.BLACK_CANDLE, TFBlocks.OMINOUS_BLACK_CANDLE);
    });
    public static final Int2ObjectMap<List<Vec2>> CANDLE_OFFSETS = (Int2ObjectMap)Util.make(() -> {
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.defaultReturnValue((Object)ImmutableList.of());
        int2objectmap.put(1, (Object)ImmutableList.of((Object)new Vec2(0.5f, 0.5f)));
        int2objectmap.put(2, (Object)ImmutableList.of((Object)new Vec2(0.375f, 0.5f), (Object)new Vec2(0.625f, 0.44f)));
        int2objectmap.put(3, (Object)ImmutableList.of((Object)new Vec2(0.5f, 0.625f), (Object)new Vec2(0.375f, 0.5f), (Object)new Vec2(0.56f, 0.44f)));
        int2objectmap.put(4, (Object)ImmutableList.of((Object)new Vec2(0.44f, 0.56f), (Object)new Vec2(0.625f, 0.56f), (Object)new Vec2(0.375f, 0.375f), (Object)new Vec2(0.56f, 0.375f)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2objectmap);
    });
    public final Block candle;

    public OminousCandleBlock(Block candle, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CANDLES, (Comparable)Integer.valueOf(1)));
        this.candle = candle;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int candles = (Integer)state.getValue((Property)CANDLES);
        int i = 1;
        for (Vec2 vec2 : (List)CANDLE_OFFSETS.get(candles)) {
            OminousCandleBlock.addParticlesAndSound(level, Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)vec2.x, (double)(OminousCandleBlock.getCurrentY(level.getGameTime(), 0.0f, pos, i++) + 0.5), (double)vec2.y), random);
        }
    }

    public static double getCurrentY(long ticks, float partialTick, BlockPos pos, int candle) {
        double time = (double)((float)ticks + partialTick) * 0.014;
        double x = Math.sin(time * 7.0 + (double)(pos.getX() * candle));
        double y = Math.sin(time * 4.2 + (double)(pos.getY() * candle));
        double z = Math.sin(time * 3.0 + (double)(pos.getZ() * candle));
        return ((x + y + z) / 4.0 * 0.5 + 0.5) * 0.25;
    }

    private static void addParticlesAndSound(Level level, Vec3 offset, RandomSource random) {
        float f = random.nextFloat();
        if (f < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.playLocalSound(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        level.addParticle((ParticleOptions)TFParticleType.OMINOUS_FLAME.get(), offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)CANDLES)) {
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            case 4 -> FOUR_AABB;
            default -> ONE_AABB;
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getAbilities().mayBuild) {
            BlockItem blockItem;
            if (stack.isEmpty()) {
                BlockState newState = (BlockState)this.candle.defaultBlockState().setValue((Property)CANDLES, (Comparable)((Integer)state.getValue((Property)CANDLES)));
                level.setBlock(pos, newState, 3);
                AbstractCandleBlock.extinguish((Player)player, (BlockState)newState, (LevelAccessor)level, (BlockPos)pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            Item newState = stack.getItem();
            if (newState instanceof BlockItem && (newState = (blockItem = (BlockItem)newState).getBlock()) instanceof CandleBlock) {
                CandleBlock candleBlock = (CandleBlock)newState;
                if ((Integer)state.getValue((Property)CANDLES) < 4 && this.candle == candleBlock) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CANDLES) + 1)), 3);
                    candleBlock.setPlacedBy(level, pos, state, (LivingEntity)player, stack);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos, stack);
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)blockItem));
                    newState = level.getBlockState(pos);
                    SoundType soundtype = newState.getSoundType((LevelReader)level, pos, (Entity)player);
                    level.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
                    stack.consume(1, (LivingEntity)player);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public static void eruptFlameParticles(Level level, BlockPos pos, BlockState state) {
        Vec3 start = Vec3.atLowerCornerOf((Vec3i)pos);
        for (Vec2 vec2 : (List)CANDLE_OFFSETS.get(((Integer)state.getValue((Property)CANDLES)).intValue())) {
            for (int j = 0; j < 5; ++j) {
                level.addParticle((ParticleOptions)TFParticleType.OMINOUS_FLAME.get(), start.x + (double)vec2.x, start.y + 0.5, start.z + (double)vec2.y, (level.getRandom().nextDouble() - 0.5) * 0.05, (double)0.015f, (level.getRandom().nextDouble() - 0.5) * 0.05);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CANDLES});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.candle);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OminousCandleBlockEntity(pos, state);
    }
}

