/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.simmetrics.StringDistance;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.Jaro;

public final class JaroWinkler
implements StringMetric,
StringDistance {
    private final Jaro jaro = new Jaro();
    private static final float PREFIX_SCALE = 0.1f;
    private static final float WINKLER_BOOST_THRESHOLD = 0.7f;
    private static final float BOOST_THRESHOLD = 0.0f;
    private static final int MAX_PREFIX_LENGTH = 4;
    private final float boostThreshold;
    private final float prefixScale;
    private final int maxPrefixLength;

    public JaroWinkler() {
        this(0.0f, 0.1f, 4);
    }

    public static JaroWinkler createWithBoostThreshold() {
        return new JaroWinkler(0.7f, 0.1f, 4);
    }

    public JaroWinkler(float boostThreshold, float prefixScale, int maxPrefixLength) {
        Preconditions.checkArgument((boostThreshold >= 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((0.0f <= prefixScale && prefixScale <= 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((maxPrefixLength >= 0 ? 1 : 0) != 0);
        this.boostThreshold = boostThreshold;
        this.prefixScale = prefixScale;
        this.maxPrefixLength = maxPrefixLength;
    }

    @Override
    public float distance(String a, String b) {
        return 1.0f - this.compare(a, b);
    }

    @Override
    public float compare(String a, String b) {
        float jaroScore = this.jaro.compare(a, b);
        if (jaroScore < this.boostThreshold) {
            return jaroScore;
        }
        int prefixLength = Math.min(Strings.commonPrefix((CharSequence)a, (CharSequence)b).length(), this.maxPrefixLength);
        return jaroScore + (float)prefixLength * this.prefixScale * (1.0f - jaroScore);
    }

    public String toString() {
        return "JaroWinkler [boostThreshold=" + this.boostThreshold + ", prefixScale=" + this.prefixScale + ", maxPrefixLength=" + this.maxPrefixLength + "]";
    }
}

