/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceIdSet
implements ASTNode {
    public static final ResourceIdSet EMPTY = new ResourceIdSet(List.of());
    public static final ResourceIdSet MATCH_ALL = new ResourceIdSet(List.of(ResourceIdentifier.MATCH_ALL));
    private final ResourceIdentifier<?, ?, ?>[] resourceIds;
    private @NotNull ResourceType<?, ?, ?> @Nullable [] referencedResourceTypes = null;

    public ResourceIdSet(ResourceIdentifier<?, ?, ?>[] resourceIds) {
        this.resourceIds = resourceIds;
    }

    public ResourceIdSet(Collection<ResourceIdentifier<?, ?, ?>> contents) {
        this(contents.toArray(new ResourceIdentifier[0]));
    }

    public ResourceType<?, ?, ?>[] getReferencedResourceTypes() {
        if (this.referencedResourceTypes == null) {
            LinkedHashSet found = new LinkedHashSet(SFMResourceTypes.getResourceTypeCount());
            for (ResourceIdentifier<?, ?, ?> resourceId : this.resourceIds) {
                found.add(resourceId.getResourceType());
            }
            this.referencedResourceTypes = found.toArray(new ResourceType[0]);
        }
        return this.referencedResourceTypes;
    }

    public boolean couldMatchMoreThanOne() {
        return this.size() > 1 || this.stream().anyMatch(ResourceIdentifier::usesRegex);
    }

    public int size() {
        return this.resourceIds.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Nullable
    public ResourceIdentifier<?, ?, ?> getMatchingFromStack(Object stack) {
        for (ResourceIdentifier<?, ?, ?> entry : this.resourceIds) {
            if (!entry.matchesStack(stack)) continue;
            return entry;
        }
        return null;
    }

    public boolean noneMatchStack(Object stack) {
        return this.getMatchingFromStack(stack) == null;
    }

    public boolean anyMatchResourceLocation(ResourceLocation location) {
        return this.stream().anyMatch(x -> x.matchesResourceLocation(location));
    }

    public String toString() {
        return "ResourceIdSet{" + this.stream().map(ResourceIdentifier::toString).collect(Collectors.joining(", ")) + "}";
    }

    public String toStringCondensed() {
        return this.stream().map(ResourceIdentifier::toStringCondensed).collect(Collectors.joining(" OR "));
    }

    public Stream<ResourceIdentifier<?, ?, ?>> stream() {
        return Arrays.stream(this.resourceIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceIdSet that = (ResourceIdSet)obj;
        return Arrays.equals(this.resourceIds, that.resourceIds);
    }

    public int hashCode() {
        return Objects.hash(this.resourceIds);
    }
}

