/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.capability.BlockEntityCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.ae2.EnergyAcceptorBlockCapabilityProvider;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.registry.SFMRegistryWrapper;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class SFMBlockCapabilityProviders {
    public static final ResourceLocation REGISTRY_ID = SFMResourceLocation.fromSFMPath("capability_provider_mappers");
    @Nullable
    public static final Supplier<EnergyAcceptorBlockCapabilityProvider> AE2_ENERGY_ACCEPTOR_CAPABILITY_PROVIDER_MAPPER;
    private static final DeferredRegister<SFMBlockCapabilityProvider<?>> REGISTERER;
    private static final Registry<SFMBlockCapabilityProvider<?>> REGISTRY;
    public static final Supplier<BlockEntityCapabilityProvider> BLOCK_ENTITY;

    public static ArrayList<SFMBlockCapabilityProvider<?>> getAllProviders() {
        ArrayList providers = new ArrayList();
        SFMBlockCapabilityProviders.registry().forEach(providers::add);
        providers.sort(Comparator.comparingInt(provider -> provider.priority()).reversed());
        return providers;
    }

    @MCVersionDependentBehaviour
    public static SFMRegistryWrapper<SFMBlockCapabilityProvider<?>> registry() {
        return new SFMRegistryWrapper(REGISTRY);
    }

    public static void register(IEventBus bus) {
        REGISTERER.register(bus);
    }

    static {
        REGISTERER = DeferredRegister.create((ResourceLocation)REGISTRY_ID, (String)"sfm");
        REGISTRY = REGISTERER.makeRegistry(registryBuilder -> {});
        BLOCK_ENTITY = REGISTERER.register("block_entity", BlockEntityCapabilityProvider::new);
        AE2_ENERGY_ACCEPTOR_CAPABILITY_PROVIDER_MAPPER = SFMModCompat.isAE2Loaded() ? REGISTERER.register("ae2/energy_acceptor", EnergyAcceptorBlockCapabilityProvider::new) : null;
    }
}

