/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IOutputResourceTracker;
import ca.teamdman.sfm.common.program.LimitedSlot;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.Stored;
import ca.teamdman.sfml.ast.Label;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class LimitedOutputSlot<STACK, ITEM, CAP>
implements LimitedSlot<STACK, ITEM, CAP> {
    public ResourceType<STACK, ITEM, CAP> type;
    public CAP handler;
    public BlockPos pos;
    public Label label;
    public int slot;
    public boolean freed;
    public IOutputResourceTracker tracker;
    public Direction direction;
    @Nullable
    private STACK stackInSlotCache = null;

    public LimitedOutputSlot(Label label, BlockPos pos, Direction direction, int slot, CAP handler, IOutputResourceTracker tracker, STACK stackCache, ResourceType<STACK, ITEM, CAP> type) {
        this.init(handler, label, pos, direction, slot, tracker, stackCache, type);
    }

    public boolean isDone() {
        if (this.slot > this.type.getSlots(this.handler) - 1) {
            return true;
        }
        STACK stack = this.getStackInSlot();
        long amount = this.type.getAmount(stack);
        long maxStackSizeForSlot = this.type.getMaxStackSizeForSlot(this.handler, this.slot);
        if (maxStackSizeForSlot > 99L) {
            if (amount >= maxStackSizeForSlot) {
                return true;
            }
        } else {
            if (amount >= maxStackSizeForSlot) {
                return true;
            }
            long maxStackSizeForStack = this.type.getMaxStackSize(stack);
            if (amount >= maxStackSizeForStack) {
                return true;
            }
        }
        if (amount != 0L && !this.tracker.matchesStack(stack)) {
            return true;
        }
        return this.tracker.isDone(this.type, stack);
    }

    public STACK getStackInSlot() {
        if (this.stackInSlotCache == null) {
            this.stackInSlotCache = this.type.getStackInSlot(this.handler, this.slot);
        }
        return this.stackInSlotCache;
    }

    public STACK insert(STACK stack, boolean simulate) {
        if (!simulate) {
            this.stackInSlotCache = null;
        }
        return this.type.insert(this.handler, this.slot, stack, simulate);
    }

    public void init(CAP handler, Label label, @Stored BlockPos pos, Direction direction, int slot, IOutputResourceTracker tracker, STACK stackCache, ResourceType<STACK, ITEM, CAP> type) {
        this.stackInSlotCache = stackCache;
        this.handler = handler;
        this.tracker = tracker;
        this.slot = slot;
        this.pos = pos;
        this.label = label;
        this.direction = direction;
        this.freed = false;
        this.type = type;
    }

    public String toString() {
        return "LimitedOutputSlot{label=" + String.valueOf(this.label) + ", pos=" + String.valueOf(this.pos) + ", direction=" + String.valueOf(this.direction) + ", slot=" + this.slot + ", cap=" + this.type.displayAsCapabilityClass() + ", tracker=" + String.valueOf(this.tracker) + "}";
    }

    @Override
    public ResourceType<STACK, ITEM, CAP> getType() {
        return this.type;
    }

    @Override
    public CAP getHandler() {
        return this.handler;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }
}

