/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.block.WaterTankBlock;
import ca.teamdman.sfm.common.blockentity.PrintingPressBlockEntity;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.Stored;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.NotImplementedException;

public class PrintingPressBlock
extends BaseEntityBlock
implements EntityBlock {
    public PrintingPressBlock() {
        super(BlockBehaviour.Properties.of().strength(5.0f, 6.0f).noOcclusion());
        this.registerDefaultState(this.defaultBlockState());
    }

    public BlockEntity newBlockEntity(@Stored BlockPos pos, BlockState state) {
        return SFMBlockEntities.PRINTING_PRESS_BLOCK_ENTITY.get().create(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void neighborChanged(BlockState pState, Level pLevel, @Stored BlockPos pPos, Block pBlock, @Stored BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (!pLevel.isClientSide && pFromPos.getY() == pPos.getY() + 1 && pLevel.getBlockState(pFromPos).getBlock() == Blocks.PISTON_HEAD && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof PrintingPressBlockEntity) {
            PrintingPressBlockEntity blockEntity2 = (PrintingPressBlockEntity)blockEntity;
            blockEntity2.performPrint();
        }
    }

    protected MapCodec<WaterTankBlock> codec() {
        throw new NotImplementedException("This isn't used until 1.20.5 apparently");
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, @NotStored BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof PrintingPressBlockEntity) {
            PrintingPressBlockEntity blockEntity2 = (PrintingPressBlockEntity)blockEntity;
            player.setItemInHand(hand, blockEntity2.acceptStack(stack));
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState pState, Level pLevel, @Stored BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            if (blockentity instanceof PrintingPressBlockEntity) {
                PrintingPressBlockEntity blockEntity = (PrintingPressBlockEntity)blockentity;
                for (ItemStack itemStack : blockEntity.getStacksToDrop()) {
                    Containers.dropItemStack((Level)pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)itemStack);
                }
                pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }
}

