/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.IAttackableBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitTileEntity;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ScreenHitBlock
extends BaseBlock
implements IAttackableBlock {
    public ScreenHitBlock() {
        super(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).pushReaction(PushReaction.BLOCK).sound(SoundType.METAL)).tileEntitySupplier(ScreenHitTileEntity::new));
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull LevelReader worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockPos screenPos = this.getScreenBlockPos((BlockGetter)worldIn, pos);
        if (screenPos == null) {
            return ItemStack.EMPTY;
        }
        BlockState screenState = worldIn.getBlockState(screenPos);
        return screenState.getBlock().getCloneItemStack(worldIn, screenPos, screenState);
    }

    public void attack(@Nonnull BlockState s, Level world, @Nonnull BlockPos pos, @Nonnull Player player) {
        this.doAttack(world, pos);
    }

    @Override
    public void doAttack(Level world, @NotNull BlockPos pos) {
        if (world.isClientSide) {
            int dz;
            int dy;
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.getBlockEntity(pos);
            int dx = screenHitTileEntity.getDx();
            BlockState state = world.getBlockState(pos.offset(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz()));
            Block block = state.getBlock();
            if (block != ScreenModule.SCREEN.block().get() && block != ScreenModule.CREATIVE_SCREEN.block().get()) {
                return;
            }
            HitResult mouseOver = SafeClientTools.getClientMouseOver();
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.getBlockEntity(pos.offset(dx, dy, dz));
            if (mouseOver instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)mouseOver;
                screenTileEntity.hitScreenClient(mouseOver.getLocation().x - (double)pos.getX() - (double)dx, mouseOver.getLocation().y - (double)pos.getY() - (double)dy, mouseOver.getLocation().z - (double)pos.getZ() - (double)dz, blockHit.getDirection(), (Direction)state.getValue((Property)ScreenBlock.HORIZ_FACING));
            }
        }
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult result) {
        return this.activate(world, pos, state, player, player.getUsedItemHand(), result);
    }

    public InteractionResult activate(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        if ((pos = this.getScreenBlockPos((BlockGetter)world, pos)) == null) {
            return InteractionResult.PASS;
        }
        Block block = world.getBlockState(pos).getBlock();
        return ((ScreenBlock)block).activate(world, pos, state, player, hand, result);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        return state;
    }

    public BlockPos getScreenBlockPos(BlockGetter world, BlockPos pos) {
        int dz;
        int dy;
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.getBlockEntity(pos);
        int dx = screenHitTileEntity.getDx();
        Block block = world.getBlockState(pos = pos.offset(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz())).getBlock();
        if (block != ScreenModule.SCREEN.block().get() && block != ScreenModule.CREATIVE_SCREEN.block().get()) {
            return null;
        }
        return pos;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        if (facing == Direction.NORTH) {
            return ScreenBlock.NORTH_AABB;
        }
        if (facing == Direction.SOUTH) {
            return ScreenBlock.SOUTH_AABB;
        }
        if (facing == Direction.WEST) {
            return ScreenBlock.WEST_AABB;
        }
        if (facing == Direction.EAST) {
            return ScreenBlock.EAST_AABB;
        }
        if (facing == Direction.UP) {
            return ScreenBlock.UP_AABB;
        }
        if (facing == Direction.DOWN) {
            return ScreenBlock.DOWN_AABB;
        }
        return ScreenBlock.BLOCK_AABB;
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public void wasExploded(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }
}

