/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableMode;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PrintingTableInputPacket(BlockPos pos, Optional<PrintingTableMode> mode, Optional<Integer> experience) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PrintingTableInputPacket> TYPE = new CustomPacketPayload.Type(BCUtil.bcLoc("printing_table_set_mode"));
    public static final StreamCodec<ByteBuf, PrintingTableInputPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PrintingTableInputPacket::pos, (StreamCodec)PrintingTableMode.STREAM_CODEC.apply(ByteBufCodecs::optional), PrintingTableInputPacket::mode, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs::optional), PrintingTableInputPacket::experience, PrintingTableInputPacket::new);

    public PrintingTableInputPacket(BlockPos pos, PrintingTableMode mode) {
        this(pos, Optional.of(mode), Optional.empty());
    }

    public PrintingTableInputPacket(BlockPos pos, int experience) {
        this(pos, Optional.empty(), Optional.of(experience));
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        BlockEntity blockEntity = player.level().getBlockEntity(this.pos);
        if (!(blockEntity instanceof PrintingTableBlockEntity)) {
            return;
        }
        PrintingTableBlockEntity blockEntity2 = (PrintingTableBlockEntity)blockEntity;
        this.mode.ifPresent(blockEntity2::setMode);
        if (this.experience.isPresent() && (player.isCreative() || player.totalExperience >= this.experience.get())) {
            blockEntity2.addExperience(this.experience.get());
            player.giveExperiencePoints(-this.experience.get().intValue());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

