/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.label;

import com.github.minecraftschurlimods.bibliocraft.content.label.LabelBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCFacingEntityBlock;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LabelBlock
extends BCFacingEntityBlock {
    private static final VoxelShape NORTH_SHAPE = ShapeUtil.combine(Shapes.box((double)0.1875, (double)0.0625, (double)0.96875, (double)0.8125, (double)0.4375, (double)1.0), Shapes.box((double)0.78125, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.4375, (double)0.96875), Shapes.box((double)0.1875, (double)0.0625, (double)0.9375, (double)0.21875, (double)0.4375, (double)0.96875), Shapes.box((double)0.21875, (double)0.0625, (double)0.9375, (double)0.78125, (double)0.09375, (double)0.96875), Shapes.box((double)0.21875, (double)0.40625, (double)0.9375, (double)0.78125, (double)0.4375, (double)0.96875));
    private static final VoxelShape EAST_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.COUNTERCLOCKWISE_90);

    public LabelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LabelBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
        };
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LabelBlockEntity) {
            LabelBlockEntity label = (LabelBlockEntity)blockEntity;
            return Math.min(15, IntStream.range(0, 3).map(e -> {
                BlockItem blockItem;
                Item patt0$temp = label.getItem(e).getItem();
                return patt0$temp instanceof BlockItem ? ((blockItem = (BlockItem)patt0$temp).getBlock() instanceof LabelBlock ? 0 : blockItem.getBlock().defaultBlockState().getLightEmission(level, pos)) : 0;
            }).sum());
        }
        return super.getLightEmission(state, level, pos);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isSecondaryUseActive()) {
            BlockPos newPos = pos.offset(((Direction)state.getValue((Property)FACING)).getOpposite().getNormal());
            return level.getBlockState(newPos).useWithoutItem(level, player, hit.withPosition(newPos));
        }
        BCUtil.openBEMenu(player, level, pos);
        return InteractionResult.SUCCESS;
    }
}

