/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.bigbook;

import com.github.minecraftschurlimods.bibliocraft.content.bigbook.BigBookContent;
import com.github.minecraftschurlimods.bibliocraft.content.bigbook.WrittenBigBookContent;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.CodecUtil;
import com.github.minecraftschurlimods.bibliocraft.util.FormattedLine;
import com.github.minecraftschurlimods.bibliocraft.util.lectern.LecternUtil;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetBigBookPageInLecternPacket(int page, Either<InteractionHand, BlockPos> target) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetBigBookPageInLecternPacket> TYPE = new CustomPacketPayload.Type(BCUtil.bcLoc("set_big_book_page_in_lectern"));
    public static final StreamCodec<ByteBuf, SetBigBookPageInLecternPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SetBigBookPageInLecternPacket::page, (StreamCodec)ByteBufCodecs.either(CodecUtil.INTERACTION_HAND_STREAM_CODEC, (StreamCodec)BlockPos.STREAM_CODEC), SetBigBookPageInLecternPacket::target, SetBigBookPageInLecternPacket::new);

    public void handle(IPayloadContext context) {
        Player player = context.player();
        this.target.ifLeft(left -> SetBigBookPageInLecternPacket.updateStack(player.getItemInHand(left), this.page));
        this.target.ifRight(right -> LecternUtil.tryGetLecternAndRun(player.level(), right, lectern -> {
            SetBigBookPageInLecternPacket.updateStack(lectern.getBook(), this.page);
            lectern.setPage(this.page);
        }));
    }

    private static void updateStack(ItemStack stack, int page) {
        if (stack.has(BCDataComponents.BIG_BOOK_CONTENT)) {
            stack.update(BCDataComponents.BIG_BOOK_CONTENT, (Object)BigBookContent.DEFAULT, data -> new BigBookContent(new ArrayList<List<FormattedLine>>(data.pages()), Math.clamp((long)page, 0, Math.max(0, data.pages().size() - 1))));
        }
        if (stack.has(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT)) {
            stack.update(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT, (Object)WrittenBigBookContent.DEFAULT, data -> new WrittenBigBookContent(new ArrayList<List<FormattedLine>>(data.pages()), data.title(), data.author(), data.generation(), Math.clamp((long)page, 0, Math.max(0, data.pages().size() - 1))));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

