/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.client.widget.ColorButton;
import com.github.minecraftschurlimods.bibliocraft.client.widget.FormattedTextArea;
import com.github.minecraftschurlimods.bibliocraft.content.fancysign.FancySignBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.fancysign.FancySignContent;
import com.github.minecraftschurlimods.bibliocraft.content.fancysign.FancySignSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.FormattedLine;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import java.util.HexFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class FancySignScreen
extends Screen {
    public static final int WIDTH = 140;
    public static final int HEIGHT = 80;
    private static final ResourceLocation BACKGROUND = BCUtil.bcLoc("textures/gui/fancy_sign.png");
    private final BlockPos pos;
    private final boolean back;
    private FormattedTextArea textArea;
    private Button modeButton;
    private Button alignmentButton;
    private EditBox colorBox;
    private EditBox sizeBox;
    private Button scaleDownButton;
    private Button scaleUpButton;

    public FancySignScreen(BlockPos pos, boolean back) {
        super(Translations.FANCY_SIGN_TITLE);
        this.pos = pos;
        this.back = back;
    }

    public void onClose() {
        BlockEntity blockEntity = ClientUtil.getLevel().getBlockEntity(this.pos);
        if (!(blockEntity instanceof FancySignBlockEntity)) {
            return;
        }
        FancySignBlockEntity sign = (FancySignBlockEntity)blockEntity;
        FancySignContent list = new FancySignContent(this.textArea.getLines());
        if (this.back) {
            sign.setBackContent(list);
        } else {
            sign.setFrontContent(list);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new FancySignSyncPacket(list, this.pos, this.back), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    protected void init() {
        BlockEntity blockEntity = ClientUtil.getLevel().getBlockEntity(this.pos);
        if (!(blockEntity instanceof FancySignBlockEntity)) {
            return;
        }
        FancySignBlockEntity sign = (FancySignBlockEntity)blockEntity;
        int leftX = (this.width - 140) / 2;
        int rightX = (this.width + 140) / 2;
        int y = (this.height - 80) / 2 - 16;
        this.textArea = (FormattedTextArea)this.addRenderableWidget((GuiEventListener)new FormattedTextArea(leftX, y, 140, 80, this.back ? sign.getBackContent().lines() : sign.getFrontContent().lines()));
        this.textArea.setOnLineChange(this::onLineChange);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_BOLD_SHORT, $ -> this.textArea.toggleStyle(Style::isBold, Style::withBold)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_BOLD)).bounds(leftX - 80, y, 16, 16).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_ITALIC_SHORT, $ -> this.textArea.toggleStyle(Style::isItalic, Style::withItalic)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_ITALIC)).bounds(leftX - 64, y, 16, 16).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_UNDERLINED_SHORT, $ -> this.textArea.toggleStyle(Style::isUnderlined, Style::withUnderlined)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_UNDERLINED)).bounds(leftX - 48, y, 16, 16).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_STRIKETHROUGH_SHORT, $ -> this.textArea.toggleStyle(Style::isStrikethrough, Style::withStrikethrough)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_STRIKETHROUGH)).bounds(leftX - 32, y, 16, 16).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_OBFUSCATED_SHORT, $ -> this.textArea.toggleStyle(Style::isObfuscated, Style::withObfuscated)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_OBFUSCATED)).bounds(leftX - 80, y + 16, 16, 16).build());
        this.modeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)this.textArea.getMode().getTranslationKey()), button -> {
            this.textArea.toggleMode();
            this.updateModeButton();
        }).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_MODE)).bounds(leftX - 64, y + 16, 48, 16).build());
        this.alignmentButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)this.textArea.getAlignment().getTranslationKey()), button -> {
            this.textArea.toggleAlignment();
            this.updateAlignmentButton();
        }).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_ALIGNMENT)).bounds(leftX - 80, y + 32, 64, 16).build());
        this.sizeBox = new EditBox(this.font, leftX - 64, y + 64, 32, 16, (Component)Component.empty());
        this.sizeBox.setFilter(s -> {
            try {
                int i = Integer.parseInt(s);
                return i >= 5 && i <= 35;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.sizeBox.setResponder(s -> {
            try {
                this.textArea.setSize(Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.scaleDownButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_SCALE_DOWN, button -> {
            int size = this.textArea.getSize() - 1;
            this.sizeBox.setValue(String.valueOf(size));
            this.sizeBox.setValue(String.valueOf(this.textArea.getSize()));
            this.updateSizeButtons(size);
        }).bounds(leftX - 80, y + 64, 16, 16).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_SCALE_DOWN_TOOLTIP)).build());
        this.addRenderableWidget((GuiEventListener)this.sizeBox);
        this.scaleUpButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_SCALE_UP, button -> {
            int size = this.textArea.getSize() + 1;
            this.sizeBox.setValue(String.valueOf(size));
            this.sizeBox.setValue(String.valueOf(this.textArea.getSize()));
            this.updateSizeButtons(size);
        }).bounds(leftX - 32, y + 64, 16, 16).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_SCALE_UP_TOOLTIP)).build());
        ChatFormatting[] colors = (ChatFormatting[])BCUtil.getChatFormattingColors().toArray(ChatFormatting[]::new);
        int colorRows = Math.floorDiv(colors.length, 4);
        this.colorBox = new EditBox(this.font, rightX + 16, y + 16 * colorRows, 64, 16, (Component)Component.empty());
        this.colorBox.setHint(Translations.FANCY_TEXT_AREA_COLOR_HINT);
        this.colorBox.setMaxLength(7);
        this.colorBox.setFilter(s -> s.isEmpty() || s.charAt(0) == '#' && s.substring(1).codePoints().allMatch(HexFormat::isHexDigit));
        this.colorBox.setResponder(s -> {
            if (s.length() <= 1) {
                return;
            }
            this.textArea.setColor(Integer.parseInt(s.substring(1), 16));
        });
        TextColor color = this.textArea.getLines().getFirst().style().getColor();
        if (color != null) {
            this.setColor(color.getValue());
        }
        for (int i = 0; i < colors.length; ++i) {
            int j = i;
            ColorButton button2 = (ColorButton)this.addRenderableWidget((GuiEventListener)new ColorButton(colors[i].getColor(), Button.builder((Component)Component.translatable((String)("color." + colors[i].getName())), $ -> this.setColor(colors[j].getColor())).bounds(rightX + 80 - 16 * (4 - i % 4), y + 16 * Math.floorDiv(i, 4), 16, 16)));
            button2.setTooltip(Tooltip.create((Component)Component.translatable((String)("color." + colors[i].getName()))));
        }
        this.addRenderableWidget((GuiEventListener)this.colorBox);
        this.onLineChange(this.textArea.getLines().getFirst());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds(leftX, y + 80 + 8, 140, 20).build());
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(BACKGROUND, (this.width - 140) / 2 - 4, (this.height - 80) / 2 - 20, 0, 0, 192, 192);
    }

    private void setColor(int color) {
        this.textArea.setColor(color);
        String hexString = Integer.toHexString(color);
        this.colorBox.setValue("#" + "0".repeat(6 - hexString.length()) + hexString);
    }

    private void updateSizeButtons(int size) {
        this.scaleDownButton.active = size > 5;
        this.scaleUpButton.active = size < 35;
    }

    private void onLineChange(FormattedLine line) {
        this.updateModeButton();
        this.updateAlignmentButton();
        TextColor color = line.style().getColor();
        this.setColor(color == null ? 0 : color.getValue());
        this.sizeBox.setValue(String.valueOf(line.size()));
        this.updateSizeButtons(line.size());
    }

    private void updateModeButton() {
        this.modeButton.setMessage((Component)Component.translatable((String)this.textArea.getMode().getTranslationKey()));
    }

    private void updateAlignmentButton() {
        this.alignmentButton.setMessage((Component)Component.translatable((String)this.textArea.getAlignment().getTranslationKey()));
    }
}

