/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.client.widget.ColorButton;
import com.github.minecraftschurlimods.bibliocraft.client.widget.FormattedTextArea;
import com.github.minecraftschurlimods.bibliocraft.content.bigbook.BigBookContent;
import com.github.minecraftschurlimods.bibliocraft.content.bigbook.BigBookSignPacket;
import com.github.minecraftschurlimods.bibliocraft.content.bigbook.BigBookSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.content.bigbook.SetBigBookPageInLecternPacket;
import com.github.minecraftschurlimods.bibliocraft.content.bigbook.WrittenBigBookContent;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.FormattedLine;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import com.github.minecraftschurlimods.bibliocraft.util.lectern.LecternUtil;
import com.github.minecraftschurlimods.bibliocraft.util.lectern.TakeLecternBookPacket;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BigBookScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = BCUtil.bcLoc("textures/gui/big_book.png");
    private static final Component OWNER = Component.translatable((String)"book.byAuthor", (Object[])new Object[]{ClientUtil.getPlayer().getName()}).withStyle(ChatFormatting.DARK_GRAY);
    private static final int BACKGROUND_WIDTH = 220;
    private static final int BACKGROUND_HEIGHT = 256;
    private static final int TEXT_WIDTH = 188;
    private static final int TEXT_HEIGHT = 204;
    private final ItemStack stack;
    private final Player player;
    private final InteractionHand hand;
    private final BlockPos lectern;
    private final boolean writable;
    private final List<List<FormattedLine>> pages;
    private int currentPage;
    private boolean isSigning = false;
    private FormattedTextArea textArea;
    private Button modeButton;
    private Button alignmentButton;
    private EditBox colorBox;
    private EditBox sizeBox;
    private Button scaleDownButton;
    private Button scaleUpButton;
    private PageButton backButton;
    private PageButton forwardButton;
    private Button finalizeButton;
    private EditBox titleBox;

    public BigBookScreen(ItemStack stack, Player player, InteractionHand hand) {
        this(stack, player, hand, null);
    }

    public BigBookScreen(ItemStack stack, Player player, BlockPos lectern) {
        this(stack, player, null, lectern);
    }

    private BigBookScreen(ItemStack stack, Player player, @Nullable InteractionHand hand, @Nullable BlockPos lectern) {
        super(stack.getHoverName());
        this.stack = stack;
        this.player = player;
        this.hand = hand;
        this.lectern = lectern;
        if (stack.has(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT)) {
            WrittenBigBookContent content = BCUtil.nonNull((WrittenBigBookContent)stack.get(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT));
            this.pages = new ArrayList<List<FormattedLine>>(content.pages());
            this.currentPage = content.currentPage();
            this.writable = false;
        } else if (stack.has(BCDataComponents.BIG_BOOK_CONTENT)) {
            BigBookContent content = BCUtil.nonNull((BigBookContent)stack.get(BCDataComponents.BIG_BOOK_CONTENT));
            this.pages = new ArrayList<List<FormattedLine>>(content.pages());
            this.currentPage = content.currentPage();
            this.writable = lectern == null;
        } else {
            this.pages = new ArrayList<List<FormattedLine>>();
            this.currentPage = 0;
            boolean bl = this.writable = lectern == null;
        }
        if (this.pages.isEmpty()) {
            this.addPage();
        }
    }

    protected void init() {
        int leftX = (this.width - 220 - 80) / 2;
        int rightX = (this.width + 220 - 80) / 2;
        if (this.isSigning) {
            this.titleBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, (this.width - 80) / 2, 50, 188, 20, (Component)Component.empty()));
            this.titleBox.setTextColor(0);
            this.titleBox.setBordered(false);
            this.titleBox.setTextShadow(false);
            this.titleBox.setResponder(s -> {
                this.titleBox.setX((this.width - 80 - this.font.width(s)) / 2);
                this.finalizeButton.active = !StringUtil.isBlank((String)s);
            });
            this.setFocused((GuiEventListener)this.titleBox);
            this.finalizeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.VANILLA_FINALIZE_BUTTON, $ -> this.finalizeBook()).bounds(rightX + 16, 208, 64, 16).build());
            this.finalizeButton.active = false;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, $ -> {
                this.isSigning = false;
                this.rebuildWidgets();
            }).bounds(rightX + 16, 224, 64, 16).build());
        } else if (this.writable) {
            this.updateTextArea();
            this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(leftX + 43, 224, false, $ -> {
                this.pages.set(this.currentPage, this.textArea.getLines());
                if (this.currentPage > 0) {
                    --this.currentPage;
                }
                this.updateButtonVisibility();
                this.updateTextArea();
            }, true));
            this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(leftX + 144, 224, true, $ -> {
                this.pages.set(this.currentPage, this.textArea.getLines());
                if (this.currentPage < 255) {
                    ++this.currentPage;
                    while (this.currentPage >= this.pages.size()) {
                        this.addPage();
                    }
                }
                this.updateButtonVisibility();
                this.updateTextArea();
            }, true));
            this.updateButtonVisibility();
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_BOLD_SHORT, $ -> this.textArea.toggleStyle(Style::isBold, Style::withBold)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_BOLD)).bounds(rightX + 16, 16, 16, 16).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_ITALIC_SHORT, $ -> this.textArea.toggleStyle(Style::isItalic, Style::withItalic)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_ITALIC)).bounds(rightX + 32, 16, 16, 16).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_UNDERLINED_SHORT, $ -> this.textArea.toggleStyle(Style::isUnderlined, Style::withUnderlined)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_UNDERLINED)).bounds(rightX + 48, 16, 16, 16).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_STRIKETHROUGH_SHORT, $ -> this.textArea.toggleStyle(Style::isStrikethrough, Style::withStrikethrough)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_STRIKETHROUGH)).bounds(rightX + 64, 16, 16, 16).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_OBFUSCATED_SHORT, $ -> this.textArea.toggleStyle(Style::isObfuscated, Style::withObfuscated)).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_OBFUSCATED)).bounds(rightX + 16, 32, 16, 16).build());
            this.modeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)this.textArea.getMode().getTranslationKey()), $ -> {
                this.textArea.toggleMode();
                this.updateModeButton();
            }).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_MODE)).bounds(rightX + 32, 32, 48, 16).build());
            this.alignmentButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)this.textArea.getAlignment().getTranslationKey()), $ -> {
                this.textArea.toggleAlignment();
                this.updateAlignmentButton();
            }).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_ALIGNMENT)).bounds(rightX + 16, 48, 64, 16).build());
            ChatFormatting[] colors = (ChatFormatting[])BCUtil.getChatFormattingColors().toArray(ChatFormatting[]::new);
            int colorRows = Math.floorDiv(colors.length, 4);
            this.colorBox = new EditBox(this.font, rightX + 16, 80 + 16 * colorRows, 64, 16, (Component)Component.empty());
            this.colorBox.setHint(Translations.FANCY_TEXT_AREA_COLOR_HINT);
            this.colorBox.setMaxLength(7);
            this.colorBox.setFilter(s -> s.isEmpty() || s.charAt(0) == '#' && s.substring(1).codePoints().allMatch(HexFormat::isHexDigit));
            this.colorBox.setResponder(s -> {
                if (s.length() <= 1) {
                    return;
                }
                this.textArea.setColor(Integer.parseInt(s.substring(1), 16));
            });
            TextColor color = this.textArea.getLines().getFirst().style().getColor();
            if (color != null) {
                this.setColor(color.getValue());
            }
            for (int i = 0; i < colors.length; ++i) {
                int j = i;
                ColorButton button2 = (ColorButton)this.addRenderableWidget((GuiEventListener)new ColorButton(colors[i].getColor(), Button.builder((Component)Component.translatable((String)("color." + colors[i].getName())), $ -> this.setColor(colors[j].getColor())).bounds(rightX + 80 - 16 * (4 - i % 4), 80 + 16 * Math.floorDiv(i, 4), 16, 16)));
                button2.setTooltip(Tooltip.create((Component)Component.translatable((String)("color." + colors[i].getName()))));
            }
            this.addRenderableWidget((GuiEventListener)this.colorBox);
            this.sizeBox = new EditBox(this.font, rightX + 32, 112 + 16 * colorRows, 32, 16, (Component)Component.empty());
            this.sizeBox.setFilter(s -> {
                try {
                    int i = Integer.parseInt(s);
                    return i >= 5 && i <= 35;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            this.sizeBox.setResponder(s -> {
                try {
                    this.textArea.setSize(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.scaleDownButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_SCALE_DOWN, $ -> {
                int size = this.textArea.getSize() - 1;
                this.sizeBox.setValue(String.valueOf(size));
                this.sizeBox.setValue(String.valueOf(this.textArea.getSize()));
                this.updateSizeButtons(size);
            }).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_SCALE_DOWN_TOOLTIP)).bounds(rightX + 16, 112 + 16 * colorRows, 16, 16).build());
            this.addRenderableWidget((GuiEventListener)this.sizeBox);
            this.scaleUpButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.FANCY_TEXT_AREA_SCALE_UP, $ -> {
                int size = this.textArea.getSize() + 1;
                this.sizeBox.setValue(String.valueOf(size));
                this.sizeBox.setValue(String.valueOf(this.textArea.getSize()));
                this.updateSizeButtons(size);
            }).tooltip(Tooltip.create((Component)Translations.FANCY_TEXT_AREA_SCALE_UP_TOOLTIP)).bounds(rightX + 64, 112 + 16 * colorRows, 16, 16).build());
            this.onLineChange(this.textArea.getLines().getFirst());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.VANILLA_SIGN_BUTTON, $ -> {
                this.isSigning = true;
                this.rebuildWidgets();
            }).bounds(rightX + 16, 208, 64, 16).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds(rightX + 16, 224, 64, 16).build());
        } else {
            this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(leftX + 83, 224, false, $ -> {
                if (this.currentPage > 0) {
                    --this.currentPage;
                }
                this.updateButtonVisibility();
                if (this.lectern != null) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetBigBookPageInLecternPacket(this.currentPage, (Either<InteractionHand, BlockPos>)Either.right((Object)this.lectern)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }, true));
            this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(leftX + 184, 224, true, $ -> {
                if (this.currentPage < this.pages.size()) {
                    ++this.currentPage;
                }
                this.updateButtonVisibility();
                if (this.lectern != null) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetBigBookPageInLecternPacket(this.currentPage, (Either<InteractionHand, BlockPos>)Either.right((Object)this.lectern)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }, true));
            this.updateButtonVisibility();
            if (this.lectern != null) {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.VANILLA_TAKE_BOOK, button -> {
                    this.onClose();
                    LecternUtil.takeLecternBook(this.player, this.player.level(), this.lectern);
                    PacketDistributor.sendToServer((CustomPacketPayload)new TakeLecternBookPacket(this.lectern), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }).bounds((this.width - 220) / 2, 260, 106, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds(this.width / 2 + 2, 260, 106, 20).build());
            } else {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds((this.width - 220) / 2, 260, 220, 20).build());
            }
        }
    }

    public boolean isPauseScreen() {
        return this.lectern == null;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.isSigning) {
            int x = (this.width - 220 - 80) / 2;
            graphics.drawString(this.font, Translations.VANILLA_EDIT_TITLE, x + 18 + (188 - this.font.width((FormattedText)Translations.VANILLA_EDIT_TITLE)) / 2, 34, 0, false);
            graphics.drawString(this.font, OWNER, x + 18 + (188 - this.font.width((FormattedText)OWNER)) / 2, 60, 0, false);
            graphics.drawWordWrap(this.font, (FormattedText)Translations.VANILLA_FINALIZE_WARNING, x + 18, 82, 188, 0);
        } else {
            MutableComponent pageIndicator = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.pages.size()});
            if (this.writable) {
                graphics.drawString(this.font, (Component)pageIndicator, (this.width - 220 - 80) / 2 + 16 + 188 - this.font.width((FormattedText)pageIndicator), 18, 0, false);
            } else {
                int x = (this.width - 220) / 2 + 16;
                FormattedTextArea.renderLines(this.pages.get(this.currentPage), graphics.pose(), (MultiBufferSource)graphics.bufferSource(), x, 26, 188);
                graphics.drawString(this.font, (Component)pageIndicator, x + 188 - this.font.width((FormattedText)pageIndicator), 18, 0, false);
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isSigning) {
            if (keyCode == 257 || keyCode == 335) {
                this.finalizeBook();
                return true;
            }
            this.clearFocus();
            this.setFocused((GuiEventListener)this.titleBox);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        int x = (this.width - (this.writable ? 300 : 220)) / 2;
        graphics.blit(BACKGROUND, x, 0, 0, 0, 256, 256);
    }

    public void onClose() {
        super.onClose();
        if (this.writable) {
            this.savePages();
            BigBookContent content = new BigBookContent(this.pages, this.currentPage);
            this.stack.set(BCDataComponents.BIG_BOOK_CONTENT, (Object)content);
            PacketDistributor.sendToServer((CustomPacketPayload)new BigBookSyncPacket(content, this.hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (this.hand != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetBigBookPageInLecternPacket(this.currentPage, (Either<InteractionHand, BlockPos>)Either.left((Object)this.hand)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (this.lectern != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetBigBookPageInLecternPacket(this.currentPage, (Either<InteractionHand, BlockPos>)Either.right((Object)this.lectern)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onLineChange(FormattedLine line) {
        this.updateModeButton();
        this.updateAlignmentButton();
        TextColor color = line.style().getColor();
        this.setColor(color == null ? 0 : color.getValue());
        this.sizeBox.setValue(String.valueOf(line.size()));
        this.updateSizeButtons(line.size());
    }

    private void updateModeButton() {
        this.modeButton.setMessage((Component)Component.translatable((String)this.textArea.getMode().getTranslationKey()));
    }

    private void updateAlignmentButton() {
        this.alignmentButton.setMessage((Component)Component.translatable((String)this.textArea.getAlignment().getTranslationKey()));
    }

    private void updateSizeButtons(int size) {
        this.scaleDownButton.active = size > 5;
        this.scaleUpButton.active = size < 35;
    }

    private void setColor(int color) {
        this.textArea.setColor(color);
        String hexString = Integer.toHexString(color);
        this.colorBox.setValue("#" + "0".repeat(6 - hexString.length()) + hexString);
    }

    private void updateButtonVisibility() {
        this.backButton.visible = !this.isSigning && this.currentPage > 0;
        this.forwardButton.visible = !this.isSigning && this.currentPage < 255 && (this.writable || this.currentPage < this.pages.size() - 1);
    }

    private void updateTextArea() {
        if (this.textArea != null) {
            this.removeWidget((GuiEventListener)this.textArea);
        }
        this.textArea = (FormattedTextArea)this.addRenderableWidget((GuiEventListener)new FormattedTextArea((this.width - 220 - 80) / 2 + 16, 26, 188, 204, this.pages.get(this.currentPage)));
        this.textArea.setOnLineChange(this::onLineChange);
    }

    private void addPage() {
        ArrayList<FormattedLine> lines = new ArrayList<FormattedLine>();
        for (int i = 0; i < 40; ++i) {
            lines.add(FormattedLine.DEFAULT);
        }
        this.pages.add(lines);
    }

    private void savePages() {
        List<FormattedLine> lines;
        this.pages.set(this.currentPage, this.textArea.getLines());
        for (int i = this.pages.size() - 1; i >= 0 && !(lines = this.pages.get(i)).stream().anyMatch(e -> e != FormattedLine.DEFAULT); --i) {
            this.pages.remove(i);
        }
        this.currentPage = Math.clamp((long)this.currentPage, 0, this.pages.size() - 1);
    }

    private void finalizeBook() {
        this.savePages();
        ItemStack stack = new ItemStack((ItemLike)BCItems.WRITTEN_BIG_BOOK.get());
        WrittenBigBookContent content = new WrittenBigBookContent(this.pages, this.titleBox.getValue(), this.player.getName().getString(), 0, this.currentPage);
        stack.set(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT, (Object)content);
        this.player.setItemInHand(this.hand, stack);
        PacketDistributor.sendToServer((CustomPacketPayload)new BigBookSignPacket(content, this.hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }
}

