/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractShapedRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.TurnAndCopyRecipe;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeMapCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class TurnAndCopyRecipeSerializer
implements RecipeSerializer<TurnAndCopyRecipe> {
    public static final DualMapCodec<RegistryFriendlyByteBuf, TurnAndCopyRecipe> CODECS = DualCompositeMapCodecs.composite(AdditionalData.CODECS, AdditionalData::new, (DualMapCodec)new DualMapCodec(RecipeSerializer.SHAPED_RECIPE.codec(), RecipeSerializer.SHAPED_RECIPE.streamCodec()), AbstractShapedRecipe::toVanilla, AdditionalData::apply);

    public MapCodec<TurnAndCopyRecipe> codec() {
        return CODECS.mapCodec();
    }

    public StreamCodec<RegistryFriendlyByteBuf, TurnAndCopyRecipe> streamCodec() {
        return CODECS.streamCodec();
    }

    private record AdditionalData(List<Integer> copySlots, boolean quarter, boolean eights) {
        private static final DualMapCodec<ByteBuf, AdditionalData> CODECS = DualCompositeMapCodecs.composite((DualMapCodec)DualCodecs.INT.listOf().optionalFieldOf("copyNBT", List.of()), AdditionalData::copySlots, (DualMapCodec)DualCodecs.BOOL.optionalFieldOf("quarter_turn", (Object)false), AdditionalData::quarter, (DualMapCodec)DualCodecs.BOOL.optionalFieldOf("eight_turn", (Object)false), AdditionalData::eights, AdditionalData::new);

        public AdditionalData(TurnAndCopyRecipe recipe) {
            this(recipe.getCopyTargets(), recipe.isQuarterTurn(), recipe.isEightTurn());
        }

        public TurnAndCopyRecipe apply(ShapedRecipe base) {
            TurnAndCopyRecipe result = new TurnAndCopyRecipe(base, this.copySlots());
            if (this.quarter()) {
                result.allowQuarterTurn();
            }
            if (this.eights()) {
                result.allowEighthTurn();
            }
            return result;
        }
    }
}

