/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.crafting.fluidaware.TurnAndCopyRecipe;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class RevolverAssemblyRecipe
extends TurnAndCopyRecipe {
    public RevolverAssemblyRecipe(ShapedRecipe vanilla, List<Integer> copyNBT) {
        super(vanilla, copyNBT);
    }

    @Override
    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.REVOLVER_ASSEMBLY_SERIALIZER.get();
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput matrix, HolderLookup.Provider access) {
        if (this.nbtCopyTargetSlot != null) {
            ItemStack out = this.getResultItem(access).copy();
            EnumMap<RevolverItem.RevolverPerk, Double> mergedPerks = new EnumMap<RevolverItem.RevolverPerk, Double>(RevolverItem.RevolverPerk.class);
            Iterator iterator = this.nbtCopyTargetSlot.iterator();
            while (iterator.hasNext()) {
                int targetSlot = (Integer)iterator.next();
                ItemStack s = matrix.getItem(targetSlot);
                RevolverItem.Perks perks = (RevolverItem.Perks)s.get(IEDataComponents.REVOLVER_PERKS);
                if (perks == null) continue;
                for (Map.Entry<RevolverItem.RevolverPerk, Double> entry : perks.perks().entrySet()) {
                    mergedPerks.merge(entry.getKey(), entry.getValue(), entry.getKey()::concat);
                }
            }
            out.set(IEDataComponents.REVOLVER_PERKS, (Object)new RevolverItem.Perks(mergedPerks));
            return out;
        }
        return super.assemble(matrix, access);
    }
}

