/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.conveyor;

import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorCacheData;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorModelRender;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.client.render.conveyor.BasicConveyorRender;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.VerticalConveyor;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.mojang.math.Transformation;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VerticalConveyorRender
extends BasicConveyorRender<VerticalConveyor> {
    public VerticalConveyorRender(ResourceLocation active, ResourceLocation inactive) {
        super(active, inactive);
    }

    @Override
    public boolean shouldRenderWall(Direction facing, ConveyorWall wall, IConveyorModelRender.RenderContext<VerticalConveyor> context) {
        return true;
    }

    @Override
    public Object getModelCacheKey(IConveyorModelRender.RenderContext<VerticalConveyor> context) {
        Direction facing;
        BasicConveyorCacheData basic = IConveyorModelRender.getDefaultData(this, context);
        VerticalConveyor instance = context.instance();
        if (instance == null) {
            return basic;
        }
        BlockEntity blockEntity = instance.getBlockEntity();
        if (!VerticalConveyor.renderBottomBelt(blockEntity, facing = context.getFacing())) {
            return basic;
        }
        record Key(BasicConveyorCacheData base, boolean inward, boolean bottomWall0, boolean bottomWall1) {
        }
        return new Key(basic, VerticalConveyor.isInwardConveyor(blockEntity, facing.getOpposite()), this.renderBottomWall(facing, ConveyorWall.LEFT, context), this.renderBottomWall(facing, ConveyorWall.RIGHT, context));
    }

    @Override
    public Transformation modifyBaseRotationMatrix(Transformation matrix) {
        return matrix.compose(new Transformation(new Vector3f(0.0f, 1.0f, 0.0f), new Quaternionf().rotateXYZ(1.5707964f, 0.0f, 0.0f), null, null));
    }

    public boolean renderBottomWall(Direction facing, ConveyorWall wall, IConveyorModelRender.RenderContext<VerticalConveyor> context) {
        return super.shouldRenderWall(facing, wall, context);
    }

    @Override
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<VerticalConveyor> context, @Nullable RenderType renderType) {
        Direction facing;
        BlockEntity blockEntity;
        VerticalConveyor instance = context.instance();
        boolean[] walls = new boolean[]{true, true};
        if (instance != null && VerticalConveyor.renderBottomBelt(blockEntity = instance.getBlockEntity(), facing = context.getFacing())) {
            TextureAtlasSprite sprite = ClientUtils.getSprite(instance.isActive() ? ConveyorBase.texture_on : ConveyorBase.texture_off);
            DyeColor dyeColour = instance.getDyeColour();
            TextureAtlasSprite spriteColour = dyeColour != null ? ClientUtils.getSprite(this.getColouredStripesTexture()) : null;
            walls = new boolean[]{this.renderBottomWall(facing, ConveyorWall.LEFT, context), this.renderBottomWall(facing, ConveyorWall.RIGHT, context)};
            if (renderType == null || renderType == RenderType.cutout()) {
                baseModel.addAll(ModelConveyor.getBaseConveyor(facing, 0.875f, ClientUtils.rotateTo(facing), ConveyorHandler.ConveyorDirection.HORIZONTAL, sprite, walls, new boolean[]{true, false}, spriteColour, dyeColour));
            }
        }
        this.addCoverQuads(baseModel, context, walls, renderType);
        return baseModel;
    }

    private void addCoverQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<VerticalConveyor> context, boolean[] walls, RenderType type) {
        Block cover = context.getCover();
        if (cover == Blocks.AIR) {
            return;
        }
        Direction facing = context.getFacing();
        VerticalConveyor conveyor = context.instance();
        BlockEntity blockEntity = conveyor != null ? conveyor.getBlockEntity() : null;
        boolean renderBottom = conveyor != null && VerticalConveyor.renderBottomBelt(blockEntity, facing);
        Function<Direction, TextureAtlasSprite> getSprite = VerticalConveyorRender.makeCoverTextureGetter(cover, type);
        if (getSprite == null) {
            return;
        }
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Matrix4 matrix = new Matrix4(facing);
        if (!renderBottom) {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.0, 0.75), new Vec3(1.0, 1.0, 1.0), matrix, facing, getSprite, colour));
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.0, 0.1875), new Vec3(0.0625, 1.0, 0.75), matrix, facing, getSprite, colour));
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.0, 0.1875), new Vec3(1.0, 1.0, 0.75), matrix, facing, getSprite, colour));
        } else {
            boolean straightInput = VerticalConveyor.isInwardConveyor(blockEntity, facing.getOpposite());
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0625, 0.9375, 0.75), new Vec3(0.9375, 1.0, 0.9375), matrix, facing, getSprite, colour));
            if (!straightInput) {
                baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.9375), new Vec3(1.0, 1.0, 1.0), matrix, facing, getSprite, colour));
            } else {
                baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.75, 0.9375), new Vec3(1.0, 1.0, 1.0), matrix, facing, getSprite, colour));
                baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.9375), new Vec3(0.0625, 0.75, 1.0), matrix, facing, getSprite, colour));
                baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.1875, 0.9375), new Vec3(1.0, 0.75, 1.0), matrix, facing, getSprite, colour));
            }
            if (walls[0]) {
                baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.1875), new Vec3(0.0625, 1.0, 0.9375), matrix, facing, getSprite, colour));
            } else {
                baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.75, 0.1875), new Vec3(0.0625, 1.0, 0.9375), matrix, facing, getSprite, colour));
            }
            if (walls[1]) {
                baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.1875, 0.1875), new Vec3(1.0, 1.0, 0.9375), matrix, facing, getSprite, colour));
            } else {
                baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.75, 0.1875), new Vec3(1.0, 1.0, 0.9375), matrix, facing, getSprite, colour));
            }
        }
    }
}

