/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.blocks.ModBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ALLamp
extends ModBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)6.0, (double)7.0, (double)12.0, (double)10.0, (double)13.0, (double)16.0), Block.box((double)6.0, (double)7.0, (double)0.0, (double)10.0, (double)13.0, (double)4.0), Block.box((double)12.0, (double)7.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0), Block.box((double)0.0, (double)7.0, (double)6.0, (double)4.0, (double)13.0, (double)10.0)};

    private static BlockBehaviour.Properties createProps(Block mainblock) {
        return BlockBehaviour.Properties.of().sound(mainblock.defaultBlockState().getSoundType()).mapColor(MapColor.NONE).pushReaction(PushReaction.NORMAL).instabreak().lightLevel(lightLevel -> 15).noCollission();
    }

    public ALLamp(Block mainblock) {
        super(mainblock, ALLamp.createProps(mainblock), Shapes.empty());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING, BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        Direction direction = this.willBeReplaced((LevelReader)context.getLevel(), context.getClickedPos()) ? Direction.UP : context.getClickedFace();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockgetter, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return SHAPES[facing.get3DDataValue()];
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockgetter, BlockPos pos, BlockState state, Fluid fluidIn) {
        return true;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == ((Direction)stateIn.getValue((Property)BlockStateProperties.FACING)).getOpposite() && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (this.willBeReplaced(level, pos)) {
            return !level.isEmptyBlock(pos.below());
        }
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        return !level.isEmptyBlock(blockpos) && level.getBlockState(blockpos).getBlock() != this;
    }

    private boolean willBeReplaced(LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        return blockstate.canBeReplaced() && !blockstate.isAir() && blockstate.getBlock() != Blocks.WATER;
    }
}

