/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.containers;

import com.direwolf20.mininggadgets.common.containers.ModificationTableCommands;
import com.direwolf20.mininggadgets.common.containers.WatchedSlot;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.setup.Registration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class ModificationTableContainer
extends AbstractContainerMenu {
    private BlockEntity tileEntity;
    private IItemHandler playerInventory;
    private List<Upgrade> upgradesCache = new ArrayList<Upgrade>();

    public ModificationTableContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        super((MenuType)Registration.MODIFICATIONTABLE_CONTAINER.get(), windowId);
        this.tileEntity = Minecraft.getInstance().level.getBlockEntity(extraData.readBlockPos());
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.setupContainerSlots();
        this.layoutPlayerInventorySlots(8, 84);
    }

    public ModificationTableContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory) {
        super((MenuType)Registration.MODIFICATIONTABLE_CONTAINER.get(), windowId);
        this.tileEntity = world.getBlockEntity(pos);
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.setupContainerSlots();
        this.layoutPlayerInventorySlots(10, 70);
    }

    public boolean stillValid(Player playerIn) {
        return ModificationTableContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.getTE().getLevel(), (BlockPos)this.tileEntity.getBlockPos()), (Player)playerIn, (Block)((Block)Registration.MODIFICATION_TABLE.get()));
    }

    private void setupContainerSlots() {
        IItemHandler cap = (IItemHandler)this.tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.tileEntity.getBlockPos(), this.tileEntity.getBlockState(), this.tileEntity, null);
        if (cap != null) {
            this.addSlot((Slot)new WatchedSlot(cap, 0, -16, 84, this::updateUpgradeCache));
        }
    }

    private void updateUpgradeCache(int index) {
        ItemStack stack = this.getSlot(index).getItem();
        if (stack.isEmpty() && !this.upgradesCache.isEmpty() || !(stack.getItem() instanceof MiningGadget)) {
            this.upgradesCache.clear();
            return;
        }
        this.upgradesCache.clear();
        this.upgradesCache = UpgradeTools.getUpgrades(stack);
    }

    public List<Upgrade> getUpgradesCache() {
        return this.upgradesCache;
    }

    public BlockEntity getTE() {
        return this.tileEntity;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) return itemstack;
        ItemStack stack = slot.getItem();
        itemstack = stack.copy();
        if (index == 0) {
            if (!this.moveItemStackTo(stack, 1, this.getItems().size(), true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stack, itemstack);
        } else if (stack.getItem() instanceof MiningGadget) {
            if (!this.moveItemStackTo(stack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
        } else if (stack.getItem() instanceof UpgradeCard) {
            if (!ModificationTableCommands.insertButton(this, stack)) return ItemStack.EMPTY;
            int maxSize = Math.min(slot.getMaxStackSize(), stack.getMaxStackSize());
            int remove = maxSize - itemstack.getCount();
            stack.shrink(remove == 0 ? 1 : remove);
            this.updateUpgradeCache(0);
        } else if (index < 29 ? !this.moveItemStackTo(stack, 29, 37, false) : index < 38 && !this.moveItemStackTo(stack, 1, 29, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == itemstack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(playerIn, stack);
        return itemstack;
    }
}

