/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive;

import aztech.modern_industrialization.MITooltips;
import com.google.common.collect.Lists;
import dev.wp.industrialization_overdrive.IOItems;
import dev.wp.industrialization_overdrive.IOText;
import dev.wp.industrialization_overdrive.IOUtil;
import dev.wp.industrialization_overdrive.item.Terminal;
import dev.wp.industrialization_overdrive.machines.blockentities.multiblock.PyrolyseOvenBlockEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public class IOTooltips {
    private static final BiParser<Boolean, Float> MAYBE_SPACED_PERCENTAGE_PARSER = (space, ratio) -> Component.literal((String)"%d%s%%".formatted((int)(ratio.floatValue() * 100.0f), space != false ? " " : "")).withStyle(MITooltips.NUMBER_TEXT);
    public static final Parser<Float> PERCENTAGE_PARSER = ratio -> MAYBE_SPACED_PERCENTAGE_PARSER.parse((Object)false, ratio);
    public static final Parser<BlockPos> POS_PARSER = pos -> Component.literal((String)"%d, %d, %d".formatted(pos.getX(), pos.getY(), pos.getZ())).withStyle(MITooltips.NUMBER_TEXT);
    public static final TooltipAttachment COILS_PYRO = TooltipAttachment.singleLine((stack, item) -> {
        if (!(item instanceof BlockItem)) return false;
        BlockItem blockItem = (BlockItem)item;
        if (!PyrolyseOvenBlockEntity.getTiersByCoil().containsKey(BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()))) return false;
        return true;
    }, (flags, ctx, stack, item) -> {
        PyrolyseOvenBlockEntity.Tier tier = PyrolyseOvenBlockEntity.getTiersByCoil().get(BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)stack.getItem()).getBlock()));
        int batchSize = tier.batchSize();
        float euCostMultiplier = tier.euCostMultiplier();
        return MICompatibleTextLine.line((TranslatableTextEnum)IOText.COILS_PYRO_TIER).arg((Object)batchSize).arg((Object)Float.valueOf(euCostMultiplier), PERCENTAGE_PARSER);
    });
    public static final TooltipAttachment TERMINAL = TooltipAttachment.multilines(IOItems.TERMINAL, (flags, ctx, stack, item) -> {
        ArrayList tooltip = Lists.newArrayList();
        if (IOUtil.isAE2Loaded) {
            GlobalPos linkPos = Terminal.getLinkPos(stack);
            if (linkPos != null) {
                tooltip.add(MICompatibleTextLine.line((TranslatableTextEnum)IOText.TERMINAL_LINK_INFO).arg((Object)linkPos.pos(), POS_PARSER));
            } else {
                tooltip.add(MICompatibleTextLine.line((TranslatableTextEnum)IOText.TERMINAL_LINK_NOT_LINKED));
            }
        }
        tooltip.add(MICompatibleTextLine.line((TranslatableTextEnum)IOText.TERMINAL_HELP_1).arg((Object)"sneak", MITooltips.KEYBIND_PARSER).arg((Object)"use", MITooltips.KEYBIND_PARSER));
        tooltip.add(MICompatibleTextLine.line((TranslatableTextEnum)(IOUtil.isAE2Loaded ? IOText.TERMINAL_HELP_2_ALT : IOText.TERMINAL_HELP_2)));
        return tooltip;
    });

    public static void init() {
    }
}

