/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking;

import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import carbonconfiglib.networking.carbon.ConfigRequestPacket;
import carbonconfiglib.networking.carbon.SaveConfigPacket;
import carbonconfiglib.networking.carbon.StateSyncPacket;
import carbonconfiglib.networking.forge.RequestConfigPacket;
import carbonconfiglib.networking.forge.SaveForgeConfigPacket;
import carbonconfiglib.networking.minecraft.RequestGameRulesPacket;
import carbonconfiglib.networking.minecraft.SaveGameRulesPacket;
import carbonconfiglib.networking.snyc.BulkSyncPacket;
import carbonconfiglib.networking.snyc.SyncPacket;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.sets.ObjectOpenHashSet;

public class CarbonNetwork {
    public static final String VERSION = "1.0.0";
    Set<UUID> clientInstalledPlayers = new ObjectOpenHashSet();
    boolean serverInstalled = false;

    public void init(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar type = event.registrar("carbonconfig").optional().versioned(VERSION);
        type.playBidirectional(SyncPacket.ID, SyncPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(BulkSyncPacket.ID, BulkSyncPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(ConfigRequestPacket.ID, ConfigRequestPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(ConfigAnswerPacket.ID, ConfigAnswerPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(SaveConfigPacket.ID, SaveConfigPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(RequestConfigPacket.ID, RequestConfigPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(SaveForgeConfigPacket.ID, SaveForgeConfigPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(RequestGameRulesPacket.ID, RequestGameRulesPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(SaveGameRulesPacket.ID, SaveGameRulesPacket.STREAM_CODEC, this::handlePacket);
        type.playBidirectional(StateSyncPacket.ID, StateSyncPacket.STREAM_CODEC, this::handlePacket);
    }

    protected void handlePacket(ICarbonPacket packet, IPayloadContext provider) {
        try {
            provider.enqueueWork(() -> packet.process(this.getPlayer(provider)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isInWorld() {
        return this.getClientPlayer() != null;
    }

    protected Player getPlayer(IPayloadContext cont) {
        Player entity = cont.player();
        return entity != null ? entity : this.getClientPlayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        Minecraft mc = Minecraft.getInstance();
        return mc == null ? null : mc.player;
    }

    public void sendToServer(ICarbonPacket packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendToAllPlayers(ICarbonPacket packet) {
        for (ServerPlayer player : this.getAllPlayers()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void onPlayerJoined(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.add(player.getUUID());
        } else {
            this.serverInstalled = true;
        }
    }

    public void onPlayerLeft(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.remove(player.getUUID());
        } else {
            this.serverInstalled = false;
        }
    }

    private List<ServerPlayer> getAllPlayers() {
        ObjectArrayList players = new ObjectArrayList();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            if (!this.isInstalledOnClient(player)) continue;
            players.add(player);
        }
        return players;
    }

    public boolean isInstalled(Player player) {
        return player instanceof ServerPlayer ? this.isInstalledOnClient((ServerPlayer)player) : this.isInstalledOnServer();
    }

    public boolean isInstalledOnClient(ServerPlayer player) {
        return this.clientInstalledPlayers.contains(player.getUUID());
    }

    public boolean isInstalledOnServer() {
        return this.serverInstalled;
    }

    public void sendToPlayer(ICarbonPacket packet, Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new RuntimeException("Sending a Packet to a Player from client is not allowed");
        }
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

