/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.IModConfigs;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.IIgnoreSearch;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.ConfigScreen;
import carbonconfiglib.gui.screen.RequestScreen;
import carbonconfiglib.gui.screen.SelectFileScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.CarbonIconButton;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;

public class ConfigSelectorScreen
extends ListScreen {
    IModConfigs configs;
    Screen parent;
    Component modName;
    Label toAdd;

    public ConfigSelectorScreen(IModConfigs configs, Screen parent) {
        this(configs, configs.getBackground(), parent);
    }

    public ConfigSelectorScreen(IModConfigs configs, BackgroundTexture.BackgroundHolder customTexture, Screen parent) {
        super((Component)Component.translatable((String)"gui.carbonconfig.select_config"), customTexture);
        this.configs = configs;
        this.parent = parent;
        this.modName = Component.literal((String)configs.getModName());
    }

    @Override
    protected void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height;
        this.addRenderableWidget((GuiEventListener)new CarbonButton(x - 80, y - 27, 160, 20, (Component)Component.translatable((String)"gui.carbonconfig.back"), T -> this.onClose()));
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.modName, this.width / 2, 8, -1);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        this.toAdd = new Label((Component)Component.translatable((String)"gui.carbonconfig.configs.local").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        this.addConfigs(ConfigType.CLIENT, false, elements);
        this.addConfigs(ConfigType.SHARED, false, elements);
        this.toAdd = null;
        if (this.minecraft.level != null) {
            if (!this.minecraft.hasSingleplayerServer()) {
                if (!this.isInstalledOnServer()) {
                    return;
                }
                if (this.isLanServer()) {
                    return;
                }
                if (!this.minecraft.player.hasPermissions(4)) {
                    return;
                }
                this.toAdd = new Label((Component)Component.translatable((String)"gui.carbonconfig.configs.multiplayer").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                this.addConfigs(ConfigType.SHARED, true, elements);
            } else {
                this.toAdd = new Label((Component)Component.translatable((String)"gui.carbonconfig.configs.world").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            }
        } else {
            this.toAdd = new Label((Component)Component.translatable((String)"gui.carbonconfig.configs.world").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        }
        this.addConfigs(ConfigType.SERVER, true, elements);
        this.toAdd = null;
    }

    private void addConfigs(ConfigType type, boolean multiplayer, Consumer<Element> elements) {
        this.configs.getConfigInstances(type).forEach(T -> {
            if (this.toAdd != null) {
                elements.accept(this.toAdd);
                this.toAdd = null;
            }
            elements.accept(new DirectConfig((IModConfig)T, this.modName, this, multiplayer));
        });
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private boolean isInstalledOnServer() {
        return CarbonConfig.NETWORK.isInstalledOnServer();
    }

    private boolean isLanServer() {
        ServerData data = this.minecraft.getCurrentServer();
        return data != null && data.isLan();
    }

    public static class Label
    extends Element
    implements IIgnoreSearch {
        public Label(Component name) {
            super(name);
        }

        @Override
        public boolean shouldIgnoreSearch() {
            return true;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.renderText(graphics, this.name, left, top + 1, width, height, ConfigElement.GuiAlign.CENTER, -1);
        }
    }

    public static class DirectConfig
    extends Element {
        List<GuiEventListener> children = new ObjectArrayList();
        Screen parent;
        IModConfig handler;
        Button button;
        CarbonIconButton reset;
        boolean multi;
        boolean multiplayer;
        ConfigScreen.Navigator nav;
        Component type;
        Component fileName;
        Component baseName;

        public DirectConfig(IModConfig handler, Component baseName, Screen parent, boolean multiplayer) {
            super((Component)Component.literal((String)handler.getFileName()));
            this.nav = new ConfigScreen.Navigator(baseName);
            this.nav.setScreenForLayer(parent);
            this.handler = handler;
            this.baseName = baseName;
            this.parent = parent;
            this.multiplayer = multiplayer;
        }

        @Override
        public void init() {
            this.multi = this.shouldCreatePick();
            if (this.multi) {
                this.button = new CarbonButton(0, 0, 82, 20, (Component)Component.translatable((String)"gui.carbonconfig.pick_file"), this::onPick);
                this.children.add((GuiEventListener)this.button);
            } else {
                this.button = new CarbonButton(0, 0, 60, 20, (Component)Component.translatable((String)"gui.carbonconfig.modify"), this::onEdit);
                this.reset = new CarbonIconButton(0, 0, 20, 20, Icon.REVERT, (Component)Component.empty(), this::reset).setIconOnly();
                this.reset.active = !this.handler.isDefault() && !this.isInWorldConfig();
                this.children.add((GuiEventListener)this.button);
                this.children.add((GuiEventListener)this.reset);
            }
            this.type = Component.translatable((String)("gui.carbonconfig.type." + this.handler.getConfigType().name().toLowerCase()));
            this.fileName = Component.literal((String)this.handler.getFileName()).withStyle(ChatFormatting.GRAY);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.setX(left + width - 82);
            this.button.setY(top + 2);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
            if (this.reset != null) {
                this.reset.setX(left + width - 20);
                this.reset.setY(top + 2);
                this.reset.render(graphics, mouseX, mouseY, partialTicks);
            }
            GuiUtils.drawScrollingString(graphics, this.font, this.type, left + 5, top, 130.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawScrollingString(graphics, this.font, this.fileName, left + 5, top + 9, 130.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawTextureRegion(graphics, left - 20, top, 22.0f, 22.0f, this.getIcon(), 16.0f, 16.0f);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        private boolean shouldCreatePick() {
            return this.handler.isDynamicConfig() && !this.isInWorldConfig();
        }

        private boolean isInWorldConfig() {
            return this.mc.level != null && (this.handler.getConfigType() == ConfigType.SERVER || this.handler.getConfigType() == ConfigType.SHARED && this.multiplayer);
        }

        private Icon getIcon() {
            return (this.multi ? Icon.MULTITYPE_ICON : Icon.TYPE_ICON).get((Object)this.handler.getConfigType());
        }

        private void onPick(Button button) {
            this.mc.setScreen((Screen)new SelectFileScreen(this.baseName, this.owner.getCustomTexture(), this.parent, this.handler));
        }

        private void reset(CarbonIconButton button) {
            this.handler.restoreDefault();
            this.handler.save();
            this.reset.active = !this.handler.isDefault();
        }

        private void onEdit(Button button) {
            if (this.isInWorldConfig() && !this.mc.hasSingleplayerServer()) {
                this.mc.setScreen((Screen)new RequestScreen(this.owner.getCustomTexture(), this.nav.add(this.type), this.parent, this.handler));
            } else {
                this.mc.setScreen((Screen)new ConfigScreen(this.nav.add(this.type), this.handler, this.parent, this.owner.getCustomTexture()));
            }
        }
    }
}

