/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.impl.forge.ForgeHelpers;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.ParseResult;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ForgeDataType<T> {
    private static final Map<Class<?>, ForgeDataType<?>> DATA_TYPES = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    public static final ForgeDataType<Boolean> BOOLEAN = new ForgeDataType<Boolean>(Boolean.class, DataType.BOOLEAN, ForgeHelpers::parseBoolean, Object::toString, null);
    public static final ForgeDataType<Integer> INTEGER = new ForgeDataType<Integer>(Integer.class, DataType.INTEGER, Helpers::parseInt, Object::toString, ForgeHelpers::getIntLimit);
    public static final ForgeDataType<Long> LONG = new ForgeDataType<Long>(Long.class, DataType.INTEGER, ForgeHelpers::parseLong, Object::toString, ForgeHelpers::getLongLimit);
    public static final ForgeDataType<Float> FLOAT = new ForgeDataType<Float>(Float.class, DataType.DOUBLE, ForgeHelpers::parseFloat, Object::toString, ForgeHelpers::getFloatLimit);
    public static final ForgeDataType<Double> DOUBLE = new ForgeDataType<Double>(Double.class, DataType.DOUBLE, Helpers::parseDouble, Object::toString, ForgeHelpers::getDoubleLimit);
    public static final ForgeDataType<String> STRING = new ForgeDataType<String>(String.class, DataType.STRING, ForgeHelpers::parseString, Object::toString, null);
    DataType type;
    Function<String, ParseResult<T>> parse;
    Function<Object, String> serialize;
    Function<Object[], String> rangeInfo;

    ForgeDataType(Class<T> clz, DataType type, Function<String, ParseResult<T>> parse, Function<Object, String> serialize, Function<Object[], String> rangeInfo) {
        this(type, parse, serialize, rangeInfo);
        DATA_TYPES.putIfAbsent(clz, this);
    }

    public ForgeDataType(DataType type, Function<String, ParseResult<T>> parse, Function<Object, String> serialize, Function<Object[], String> rangeInfo) {
        this.type = type;
        this.parse = parse;
        this.serialize = serialize;
        this.rangeInfo = rangeInfo;
    }

    public DataType getDataType() {
        return this.type;
    }

    public boolean isEnum() {
        return false;
    }

    public String getLimitations(ModConfigSpec.ValueSpec spec) {
        if (this.rangeInfo == null) {
            return "";
        }
        Object[] data = ForgeHelpers.getRangeInfo(spec);
        return data == null ? "" : this.rangeInfo.apply(data);
    }

    public ParseResult<T> parse(String input) {
        return this.parse.apply(input);
    }

    public String serialize(Object value) {
        return this.serialize.apply(value);
    }

    public static void registerDataType(Class<?> clz, ForgeDataType<?> type) {
        DATA_TYPES.putIfAbsent(clz, type);
    }

    public static <T> ForgeDataType<T> getDataByType(Class<T> clz) {
        if (clz == null) {
            return null;
        }
        ForgeDataType<?> type = DATA_TYPES.get(clz);
        return type == null && clz.isEnum() ? EnumDataType.create(clz) : type;
    }

    public static class EnumDataType<T extends Enum<T>>
    extends ForgeDataType<T> {
        Class<T> clz;

        EnumDataType(Class<T> clz) {
            super(clz, DataType.ENUM, null, null, null);
            this.clz = clz;
        }

        @Override
        public boolean isEnum() {
            return true;
        }

        @Override
        public ParseResult<T> parse(String input) {
            try {
                return ParseResult.success(Enum.valueOf(this.clz, input));
            }
            catch (Exception e) {
                return ParseResult.error(input, e, "Value must be one of the following: " + Arrays.toString(this.toArray(null)));
            }
        }

        @Override
        public String getLimitations(ModConfigSpec.ValueSpec spec) {
            return "Value must be one of the following: " + Arrays.toString(this.toArray(spec));
        }

        public List<ISuggestionProvider.Suggestion> getSuggestions(ModConfigSpec.ValueSpec spec) {
            ObjectArrayList result = new ObjectArrayList();
            ISuggestionProvider.enums(this.clz).provideSuggestions(((List)result)::add, enumConstant -> spec.test((Object)enumConstant.getValue()));
            return result;
        }

        @Override
        public String serialize(Object value) {
            if (value instanceof String) {
                return (String)value;
            }
            return ((Enum)value).name();
        }

        public static <T> ForgeDataType<T> create(Class<T> clz) {
            return new EnumDataType<T>(clz);
        }

        private String[] toArray(ModConfigSpec.ValueSpec spec) {
            Enum[] array = (Enum[])this.clz.getEnumConstants();
            ObjectArrayList values = new ObjectArrayList();
            int m = array.length;
            for (int i = 0; i < m; ++i) {
                if (spec != null && !spec.test((Object)array[i])) continue;
                values.add(array[i].name());
            }
            return values.toArray(new String[values.size()]);
        }
    }
}

