/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.api;

import carbonconfiglib.gui.api.INode;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface IConfigNode {
    public List<IConfigNode> getChildren();

    public INode asNode();

    public IStructuredData.StructureType getDataStructure();

    public boolean isLeaf();

    public boolean isRoot();

    public boolean isChanged();

    public void setPrevious();

    public void setDefault();

    public void save();

    public boolean requiresRestart();

    public boolean requiresReload();

    public String getNodeName();

    public Component getName();

    public Component getTooltip();

    public static MutableComponent createLabel(String name, String translationKey) {
        return translationKey != null && I18n.exists((String)translationKey) ? Component.translatable((String)translationKey) : IConfigNode.createLabel(name);
    }

    public static MutableComponent createLabel(String name) {
        MutableComponent comp = Component.empty();
        for (String s : name.split("\\-|\\_|(?<!^)(?=[A-Z][a-z])|(?<!(^|[A-Z]))(?=[A-Z])")) {
            if (s.isEmpty()) continue;
            String first = Character.toString(Character.toLowerCase(s.charAt(0)));
            comp.append(s.toLowerCase().replaceFirst(first, first.toUpperCase()).trim()).append(" ");
        }
        return comp;
    }
}

