/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IDAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(IDAssigner.class);
    public static final String COMPUTER = "computer";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type ID_TOKEN = new TypeToken<Map<String, Integer>>(){}.getType();
    private final Path idFile;
    private final Path newIdFile;
    @Nullable
    private Map<String, Integer> ids;

    public IDAssigner(Path path) {
        this.idFile = path;
        this.newIdFile = path.resolveSibling(String.valueOf(path.getFileName()) + ".new");
    }

    public synchronized int getNextId(String kind) {
        Integer existing;
        if (this.ids == null) {
            this.ids = this.loadIds();
        }
        int next = (existing = this.ids.get(kind)) == null ? 0 : existing + 1;
        this.ids.put(kind, next);
        try {
            try (FileChannel channel = FileChannel.open(this.newIdFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                BufferedWriter writer = new BufferedWriter(Channels.newWriter((WritableByteChannel)channel, StandardCharsets.UTF_8));
                GSON.toJson(this.ids, (Appendable)writer);
                ((Writer)writer).flush();
                channel.force(false);
            }
            try {
                Files.move(this.newIdFile, this.idFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (UnsupportedOperationException | AtomicMoveNotSupportedException e) {
                Files.move(this.newIdFile, this.idFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            LOG.error("Cannot update ID file '{}'", (Object)this.idFile, (Object)e);
        }
        return next;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Integer> loadIds() {
        if (Files.isRegularFile(this.idFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.idFile, StandardCharsets.UTF_8);){
                Map result = (Map)GSON.fromJson((Reader)reader, ID_TOKEN);
                if (result != null) {
                    Map map = result;
                    return map;
                }
                LOG.error("ID file {} is corrupted, computer IDs may be duplicated", (Object)this.idFile);
                return new HashMap<String, Integer>();
            }
            catch (Exception e) {
                LOG.error("Cannot load id file '" + String.valueOf(this.idFile) + "'", (Throwable)e);
                return new HashMap<String, Integer>();
            }
        }
        try {
            Files.createDirectories(this.idFile.getParent(), new FileAttribute[0]);
            return new HashMap<String, Integer>();
        }
        catch (IOException e) {
            LOG.error("Cannot create owning directory, IDs will not be persisted", (Throwable)e);
        }
        return new HashMap<String, Integer>();
    }
}

