/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.BlockCodecs;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TurtleBlock
extends AbstractComputerBlock<TurtleBlockEntity>
implements SimpleWaterloggedBlock {
    private static final MapCodec<TurtleBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), BlockCodecs.blockEntityCodec(x -> x.type)).apply((Applicative)instance, TurtleBlock::new));
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final float IMMUNE_EXPLOSION_RESISTANCE = 2000.0f;
    private static final VoxelShape DEFAULT_SHAPE = Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    private final BlockEntityTicker<TurtleBlockEntity> clientTicker = (level, pos, state, computer) -> computer.clientTick();

    public TurtleBlock(BlockBehaviour.Properties settings, RegistryEntry<BlockEntityType<TurtleBlockEntity>> type) {
        super(settings, type);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WaterloggableHelpers.WATERLOGGED});
    }

    protected MapCodec<? extends TurtleBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 vec3;
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            vec3 = turtle.getRenderOffset(1.0f);
        } else {
            vec3 = Vec3.ZERO;
        }
        Vec3 offset = vec3;
        return offset.equals((Object)Vec3.ZERO) ? DEFAULT_SHAPE : DEFAULT_SHAPE.move(offset.x, offset.y, offset.z);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext placement) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placement.getHorizontalDirection())).setValue((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(placement)));
    }

    protected FluidState getFluidState(BlockState state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction side, BlockState otherState, LevelAccessor world, BlockPos pos, BlockPos otherPos) {
        WaterloggableHelpers.updateShape(state, world, pos);
        return state;
    }

    protected final void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        TurtleBlockEntity t;
        BlockEntity blockEntity;
        if (state.is(newState.getBlock())) {
            return;
        }
        TurtleBlockEntity turtle = !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TurtleBlockEntity && !(t = (TurtleBlockEntity)blockEntity).hasMoved() ? t : null;
        super.onRemove(state, level, pos, newState, isMoving);
        if (turtle != null) {
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)turtle);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)blockEntity;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                turtle.setOwningPlayer(player.getGameProfile());
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack currentItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (currentItem.getItem() == Items.NAME_TAG && currentItem.has(DataComponents.CUSTOM_NAME) && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)blockEntity;
            if (!level.isClientSide) {
                computer.setLabel(currentItem.getHoverName().getString());
                currentItem.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(currentItem, state, level, pos, player, hand, hit);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        Entity exploder = explosion.getDirectSourceEntity();
        if (exploder instanceof LivingEntity || exploder instanceof AbstractHurtingProjectile) {
            return 2000.0f;
        }
        return this.getExplosionResistance();
    }

    @Override
    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> getTicker(Level level, BlockState state, BlockEntityType<U> type) {
        return level.isClientSide ? BlockEntityHelpers.createTickerHelper(type, (BlockEntityType)this.type.get(), this.clientTicker) : super.getTicker(level, state, type);
    }
}

