/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import dan200.computercraft.data.PrettyJsonWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;

public record PrettyDataProvider<T extends DataProvider>(T provider) implements DataProvider
{
    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        return this.provider.run((CachedOutput)new Output(cachedOutput));
    }

    public String getName() {
        return this.provider.getName();
    }

    private record Output(CachedOutput output) implements CachedOutput
    {
        private static final HashFunction HASH_FUNCTION = Hashing.sha1();

        public void writeIfNeeded(Path path, byte[] bytes, HashCode hashCode) throws IOException {
            if (path.getFileName().toString().endsWith(".json")) {
                bytes = PrettyJsonWriter.reformat(bytes);
                hashCode = HASH_FUNCTION.hashBytes(bytes);
            }
            this.output.writeIfNeeded(path, bytes, hashCode);
        }
    }
}

