/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.server;

import com.thevortex.allthemodium.datagen.builder.ShapedAncientStones;
import com.thevortex.allthemodium.datagen.builder.ShapedBlockBuilder;
import com.thevortex.allthemodium.datagen.builder.ShapedIngotBuilder;
import com.thevortex.allthemodium.registry.ModRegistry;
import com.thevortex.allthemodium.registry.TagRegistry;
import java.util.concurrent.CompletableFuture;
import net.allthemods.alltheores.registry.ATOTagRegistry;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ATMCraftingRecipes
extends RecipeProvider {
    public ATMCraftingRecipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    private ResourceLocation recipeDir(String typeIn, String typeOut) {
        return ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)(typeIn + "_from_" + typeOut));
    }

    private ShapedRecipeBuilder shaped(ItemLike provider, int integer) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)provider, (int)integer).group("allthemodium");
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)provider).group("allthemodium");
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> hasTag(TagKey<Item> tagKey) {
        return ATMCraftingRecipes.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tagKey).build()});
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.buildShapedRecipes(consumer);
        this.buildShapelessRecipes(consumer);
        this.buildSmeltingRecipes(consumer);
        this.buildBlastingRecipes(consumer);
    }

    protected void buildShapedRecipes(RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.RAW_ALLTHEMODIUM_BLOCK.get())).group("allthemodium").requires(Ingredient.of(TagRegistry.RAW_ALLTHEMODIUM), 9).unlockedBy("has_raw_allthemodium", ATMCraftingRecipes.hasTag(TagRegistry.RAW_ALLTHEMODIUM)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.RAW_VIBRANIUM_BLOCK.get())).group("allthemodium").requires(Ingredient.of(TagRegistry.RAW_VIBRANIUM), 9).unlockedBy("has_raw_vibranium", ATMCraftingRecipes.hasTag(TagRegistry.RAW_VIBRANIUM)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.RAW_UNOBTAINIUM_BLOCK.get())).group("allthemodium").requires(Ingredient.of(TagRegistry.RAW_UNOBTAINIUM), 9).unlockedBy("has_raw_unobtainium", ATMCraftingRecipes.hasTag(TagRegistry.RAW_UNOBTAINIUM)).save(consumer);
        this.shaped((ItemLike)ModRegistry.PIGLICH_HEART_BLOCK_ITEM.get()).pattern("nnn").pattern("nnn").pattern("nnn").define(Character.valueOf('n'), (ItemLike)ModRegistry.PIGLICH_HEART.get()).unlockedBy("has_piglich_heartt", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModRegistry.PIGLICH_HEART.get()}).build()})).save(consumer);
        this.shaped((ItemLike)ModRegistry.ALLTHEMODIUM_APPLE.get()).pattern("nnn").pattern("nan").pattern("nnn").define(Character.valueOf('n'), TagRegistry.ALLTHEMODIUM_NUGGET).define(Character.valueOf('a'), (ItemLike)Items.APPLE).unlockedBy("has_allthemodium_nugget", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(TagRegistry.ALLTHEMODIUM_NUGGET).build()})).save(consumer);
        this.shaped((ItemLike)ModRegistry.ALLTHEMODIUM_CARROT.get()).pattern("nnn").pattern("nan").pattern("nnn").define(Character.valueOf('n'), TagRegistry.ALLTHEMODIUM_NUGGET).define(Character.valueOf('a'), (ItemLike)Items.CARROT).unlockedBy("has_allthemodium_nugget", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(TagRegistry.ALLTHEMODIUM_NUGGET).build()})).save(consumer);
        this.shaped((ItemLike)ModRegistry.TELEPORT_PAD_ITEM.get()).pattern(" n ").pattern("nan").pattern(" n ").define(Character.valueOf('n'), TagRegistry.ALLTHEMODIUM_NUGGET).define(Character.valueOf('a'), (ItemLike)Items.ENDER_PEARL).unlockedBy("has_allthemodium_nugget", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(TagRegistry.ALLTHEMODIUM_NUGGET).build()})).unlockedBy("has_ender_pearl", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{Items.ENDER_PEARL}).build()})).save(consumer);
        String hasCondition = "has_item";
        ShapedAncientStones.builder(TagRegistry.DEMONIC_WOODEN_PLANKS_ITEM).setBookShelf(ModRegistry.DEMONIC_BOOKSHELF_ITEM).setDoor(ModRegistry.DEMONIC_DOOR_ITEM).setTrapDoor(ModRegistry.DEMONIC_TRAP_DOOR_ITEM).setStairs(ModRegistry.DEMONIC_WOODEN_STAIRS_ITEM).setFence(ModRegistry.DEMONIC_WOOD_FENCE_ITEM).setFenceGate(ModRegistry.DEMONIC_WOOD_FENCE_GATE_ITEM).setSlab(ModRegistry.DEMONIC_WOODEN_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.SOUL_WOODEN_PLANKS_ITEM).setBookShelf(ModRegistry.SOUL_BOOKSHELF_ITEM).setDoor(ModRegistry.SOUL_DOOR_ITEM).setTrapDoor(ModRegistry.SOUL_TRAP_DOOR_ITEM).setStairs(ModRegistry.SOUL_WOODEN_STAIRS_ITEM).setFence(ModRegistry.SOUL_WOOD_FENCE_ITEM).setFenceGate(ModRegistry.SOUL_WOOD_FENCE_GATE_ITEM).setSlab(ModRegistry.SOUL_WOODEN_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.ANCIENT_WOODEN_PLANKS_ITEM).setBookShelf(ModRegistry.ANCIENT_BOOKSHELF_ITEM).setTrapDoor(ModRegistry.ANCIENT_TRAP_DOOR_ITEM).setDoor(ModRegistry.ANCIENT_DOOR_ITEM).setStairs(ModRegistry.ANCIENT_WOODEN_STAIRS_ITEM).setFence(ModRegistry.ANCIENT_WOOD_FENCE_ITEM).setFenceGate(ModRegistry.ANCIENT_WOOD_FENCE_GATE_ITEM).setSlab(ModRegistry.ANCIENT_WOODEN_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.ANCIENT_STONE_BRICKS_ITEM).setStairs(ModRegistry.ANCIENT_STONE_BRICK_STAIRS_ITEM).setWall(ModRegistry.ANCIENT_STONE_BRICK_WALL_ITEM).setSlab(ModRegistry.ANCIENT_STONE_BRICK_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.ANCIENT_STONE_ITEM).setBrick(ModRegistry.ANCIENT_STONE_BRICKS_ITEM).setStairs(ModRegistry.ANCIENT_STONE_STAIRS_ITEM).setWall(ModRegistry.ANCIENT_STONE_WALL_ITEM).setSlab(ModRegistry.ANCIENT_STONE_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.ANCIENT_MOSSY_STONE_ITEM).setStairs(ModRegistry.ANCIENT_MOSSY_STONE_STAIRS_ITEM).setWall(ModRegistry.ANCIENT_MOSSY_STONE_WALL_ITEM).setSlab(ModRegistry.ANCIENT_MOSSY_STONE_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.ANCIENT_SMOOTH_STONE_ITEM).setStairs(ModRegistry.ANCIENT_SMOOTH_STONE_STAIRS_ITEM).setWall(ModRegistry.ANCIENT_SMOOTH_STONE_WALL_ITEM).setSlab(ModRegistry.ANCIENT_SMOOTH_STONE_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.ANCIENT_POLISHED_STONE_ITEM).setStairs(ModRegistry.ANCIENT_POLISHED_STONE_STAIRS_ITEM).setWall(ModRegistry.ANCIENT_POLISHED_STONE_WALL_ITEM).setSlab(ModRegistry.ANCIENT_POLISHED_STONE_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.ANCIENT_CHISELED_STONE_BRICKS_ITEM).setStairs(ModRegistry.ANCIENT_CHISELED_STONE_STAIRS_ITEM).setWall(ModRegistry.ANCIENT_CHISELED_STONE_BRICK_WALL_ITEM).setSlab(ModRegistry.ANCIENT_CHISELED_STONE_SLABS_ITEM).build(consumer);
        ShapedAncientStones.builder(TagRegistry.ANCIENT_CRACKED_STONE_BRICKS_ITEM).setStairs(ModRegistry.ANCIENT_CRACKED_STONE_STAIRS_ITEM).setWall(ModRegistry.ANCIENT_CRACKED_STONE_BRICK_WALL_ITEM).setSlab(ModRegistry.ANCIENT_CRACKED_STONE_SLABS_ITEM).build(consumer);
        ShapedBlockBuilder.builder(TagRegistry.ALLTHEMODIUM_INGOT).setBlock(ModRegistry.ALLTHEMODIUM_BLOCK_ITEM).setGear(ModRegistry.ATM_GEAR).setPlate(ModRegistry.ATM_PLATE).setRod(ModRegistry.ATM_ROD).build(consumer);
        ShapedBlockBuilder.builder(TagRegistry.VIBRANIUM_INGOT).setBlock(ModRegistry.VIBRANIUM_BLOCK_ITEM).setGear(ModRegistry.VIB_GEAR).setPlate(ModRegistry.VIB_PLATE).setRod(ModRegistry.VIB_ROD).build(consumer);
        ShapedBlockBuilder.builder(TagRegistry.UNOBTAINIUM_INGOT).setBlock(ModRegistry.UNOBTAINIUM_BLOCK_ITEM).setGear(ModRegistry.ONOB_GEAR).setPlate(ModRegistry.ONOB_PLATE).setRod(ModRegistry.ONOB_ROD).build(consumer);
        ShapedBlockBuilder.builder(TagRegistry.UNOBTAINIUM_ALLTHEMODIUM_INGOT).setBlock(ModRegistry.UA_ALLOY_ITEM).build(consumer);
        ShapedBlockBuilder.builder(TagRegistry.UNOBTAINIUM_VIBRANIUM_INGOT).setBlock(ModRegistry.UV_ALLOY_ITEM).build(consumer);
        ShapedBlockBuilder.builder(TagRegistry.VIBRANIUM_ALLTHEMODIUM_INGOT).setBlock(ModRegistry.VA_ALLOY_ITEM).build(consumer);
        ShapedIngotBuilder.builder(TagRegistry.ALLTHEMODIUM_NUGGET).setIngot(ModRegistry.ALLTHEMODIUM_INGOT).build(consumer);
        ShapedIngotBuilder.builder(TagRegistry.VIBRANIUM_NUGGET).setIngot(ModRegistry.VIBRANIUM_INGOT).build(consumer);
        ShapedIngotBuilder.builder(TagRegistry.UNOBTAINIUM_NUGGET).setIngot(ModRegistry.UNOBTAINIUM_INGOT).build(consumer);
    }

    protected void buildBlastingRecipes(RecipeOutput consumer) {
        String hasCondition = "has_item";
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.ANCIENT_STONE_ITEM.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_SMOOTH_STONE_ITEM.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ANCIENT_STONE_ITEM.get()))).save(consumer, this.recipeDir("ancient_smooth_stone", "ancient_stone_blasting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.RAW_ALLTHEMODIUM.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_ALLTHEMODIUM.get()))).save(consumer, this.recipeDir("allthemodium_ingot", "raw_blasting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.RAW_VIBRANIUM.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.VIBRANIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_VIBRANIUM.get()))).save(consumer, this.recipeDir("vibranium_ingot", "raw_blasting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.RAW_UNOBTAINIUM.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_UNOBTAINIUM.get()))).save(consumer, this.recipeDir("unobtainium_ingot", "raw_blasting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.ALLTHEMODIUM_DUST.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_DUST.get()))).save(consumer, this.recipeDir("allthemodium_ingot", "dust_blasting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.VIBRANIUM_DUST.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.VIBRANIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.VIBRANIUM_DUST.get()))).save(consumer, this.recipeDir("vibranium_ingot", "dust_blasting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.UNOBTAINIUM_DUST.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_DUST.get()))).save(consumer, this.recipeDir("unobtainium_ingot", "dust_blasting"));
    }

    protected void buildShapelessRecipes(RecipeOutput consumer) {
        String hasCondition = "has_item";
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.DEMONIC_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.DEMONIC_LOG_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.DEMONIC_LOG_ITEM.get()))).save(consumer, this.recipeDir("demonic_planks", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.SOUL_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.SOUL_LOG_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.SOUL_LOG_ITEM.get()))).save(consumer, this.recipeDir("soul_planks", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.SOUL_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.SOUL_LOG_0_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.SOUL_LOG_0_ITEM.get()))).save(consumer, this.recipeDir("soul_planks_0", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.SOUL_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.SOUL_LOG_1_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.SOUL_LOG_1_ITEM.get()))).save(consumer, this.recipeDir("soul_planks_1", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.SOUL_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.SOUL_LOG_2_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.SOUL_LOG_2_ITEM.get()))).save(consumer, this.recipeDir("soul_planks_2", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.ANCIENT_LOG_0_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ANCIENT_LOG_0_ITEM.get()))).save(consumer, this.recipeDir("ancient_planks", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.ANCIENT_LOG_1_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ANCIENT_LOG_1_ITEM.get()))).save(consumer, this.recipeDir("ancient_planks_1", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.ANCIENT_LOG_2_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ANCIENT_LOG_2_ITEM.get()))).save(consumer, this.recipeDir("ancient_planks_2", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_PLANKS.get()), (int)4).requires((ItemLike)ModRegistry.ANCIENT_LOG_STRIPPED_ITEM.get()).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ANCIENT_LOG_STRIPPED_ITEM.get()))).save(consumer, this.recipeDir("ancient_planks_3", "shapelesscrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_MOSSY_STONE_ITEM.get()), (int)1).requires((ItemLike)ModRegistry.ANCIENT_STONE_ITEM.get()).requires((ItemLike)Items.VINE).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ANCIENT_STONE_ITEM.get()))).save(consumer, this.recipeDir("ancient_mossy_stone", "vinecrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_POLISHED_STONE_ITEM.get()), (int)1).requires((ItemLike)ModRegistry.ANCIENT_SMOOTH_STONE_ITEM.get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ANCIENT_SMOOTH_STONE_ITEM.get()))).save(consumer, this.recipeDir("ancient_polished_stone", "waxing"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_CRACKED_STONE_BRICKS_ITEM.get()), (int)1).requires(TagRegistry.ANCIENT_STONE_BRICKS_ITEM).requires(ATOTagRegistry.ORE_HAMMERS).unlockedBy("has_item", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(TagRegistry.ANCIENT_STONE_BRICKS_ITEM).build()})).save(consumer, this.recipeDir("ancient_cracked_stone_bricks", "crushing"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_CHISELED_STONE_BRICKS_ITEM.get()), (int)1).requires(TagRegistry.ANCIENT_CRACKED_STONE_BRICKS_ITEM).requires(ATOTagRegistry.ORE_HAMMERS).unlockedBy("has_item", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(TagRegistry.ANCIENT_CRACKED_STONE_BRICKS_ITEM).build()})).save(consumer, this.recipeDir("ancient_chiseled_stone_bricks", "crushing"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_DUST.get()), (int)2).requires((ItemLike)ModRegistry.RAW_ALLTHEMODIUM.get()).requires(ATOTagRegistry.ORE_HAMMERS).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_ALLTHEMODIUM.get()))).save(consumer, this.recipeDir("allthemodium_dust", "ore_crushing"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_INGOT.get()), (int)9).requires(TagRegistry.ALLTHEMODIUM_BLOCK_ITEM).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_BLOCK_ITEM.get()))).save(consumer, this.recipeDir("allthemodium_ingot", "block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_NUGGET.get()), (int)9).requires(TagRegistry.ALLTHEMODIUM_INGOT).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_INGOT.get()))).save(consumer, this.recipeDir("allthemodium_nugget", "ingot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.VIBRANIUM_DUST.get()), (int)2).requires((ItemLike)ModRegistry.RAW_VIBRANIUM.get()).requires(ATOTagRegistry.ORE_HAMMERS).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_VIBRANIUM.get()))).save(consumer, this.recipeDir("vibranium_dust", "ore_crushing"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_DUST.get()), (int)2).requires((ItemLike)ModRegistry.RAW_UNOBTAINIUM.get()).requires(ATOTagRegistry.ORE_HAMMERS).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_UNOBTAINIUM.get()))).save(consumer, this.recipeDir("unobtainium_dust", "ore_crushing"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.VIBRANIUM_INGOT.get()), (int)9).requires(TagRegistry.VIBRANIUM_BLOCK_ITEM).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.VIBRANIUM_BLOCK_ITEM.get()))).save(consumer, this.recipeDir("vibranium_ingot", "block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.VIBRANIUM_NUGGET.get()), (int)9).requires(TagRegistry.VIBRANIUM_INGOT).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.VIBRANIUM_INGOT.get()))).save(consumer, this.recipeDir("vibranium_nugget", "ingot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_INGOT.get()), (int)9).requires(TagRegistry.UNOBTAINIUM_BLOCK_ITEM).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_BLOCK_ITEM.get()))).save(consumer, this.recipeDir("unobtainium_ingot", "block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_NUGGET.get()), (int)9).requires(TagRegistry.UNOBTAINIUM_INGOT).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_INGOT.get()))).save(consumer, this.recipeDir("unobtainium_nugget", "ingot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.RAW_ALLTHEMODIUM.get()), (int)9).requires(TagRegistry.RAW_ALLTHEMODIUM_BLOCK).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_ALLTHEMODIUM_BLOCK_ITEM.get()))).save(consumer, this.recipeDir("raw_allthemodium", "block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.RAW_VIBRANIUM.get()), (int)9).requires(TagRegistry.RAW_VIBRANIUM_BLOCK).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_VIBRANIUM_BLOCK_ITEM.get()))).save(consumer, this.recipeDir("raw_vibranium", "block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.RAW_UNOBTAINIUM.get()), (int)9).requires(TagRegistry.RAW_UNOBTAINIUM_BLOCK).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_UNOBTAINIUM_BLOCK_ITEM.get()))).save(consumer, this.recipeDir("raw_unobtainium", "block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_ALLTHEMODIUM_ALLOY.get()), (int)9).requires(TagRegistry.UNOBTAINIUM_ALLTHEMODIUM_BLOCK).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.UA_ALLOY_ITEM.get()))).save(consumer, this.recipeDir("unobtainium_allthemodium_alloy_ingot", "block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_VIBRANIUM_ALLOY.get()), (int)9).requires(TagRegistry.UNOBTAINIUM_VIBRANIUM_BLOCK).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.UV_ALLOY_ITEM.get()))).save(consumer, this.recipeDir("unobtainium_vibranium_alloy_ingot", "block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.VIBRANIUM_ALLTHEMODIUM_ALLOY.get()), (int)9).requires(TagRegistry.VIBRANIUM_ALLTHEMODIUM_BLOCK).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.VA_ALLOY_ITEM.get()))).save(consumer, this.recipeDir("vibranium_allthemodium_alloy_ingot", "block"));
    }

    protected void buildSmeltingRecipes(RecipeOutput consumer) {
        String hasCondition = "has_item";
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.ANCIENT_STONE_ITEM.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ANCIENT_SMOOTH_STONE_ITEM.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ANCIENT_STONE_ITEM.get()))).save(consumer, this.recipeDir("ancient_smooth_stone", "ancient_stone_smelting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.RAW_ALLTHEMODIUM.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_ALLTHEMODIUM.get()))).save(consumer, this.recipeDir("allthemodium_ingot", "raw_smelting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.RAW_VIBRANIUM.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.VIBRANIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_VIBRANIUM.get()))).save(consumer, this.recipeDir("vibranium_ingot", "raw_smelting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.RAW_UNOBTAINIUM.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.RAW_UNOBTAINIUM.get()))).save(consumer, this.recipeDir("unobtainium_ingot", "raw_smelting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.ALLTHEMODIUM_DUST.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.ALLTHEMODIUM_DUST.get()))).save(consumer, this.recipeDir("allthemodium_ingot", "dust_smelting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.VIBRANIUM_DUST.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.VIBRANIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.VIBRANIUM_DUST.get()))).save(consumer, this.recipeDir("vibranium_ingot", "dust_smelting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.UNOBTAINIUM_DUST.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_INGOT.get()), (float)0.15f, (int)200).unlockedBy("has_item", RecipeProvider.has((ItemLike)((ItemLike)ModRegistry.UNOBTAINIUM_DUST.get()))).save(consumer, this.recipeDir("unobtainium_ingot", "dust_smelting"));
    }
}

