/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.builder;

import com.thevortex.allthemodium.datagen.RecipeException;
import com.thevortex.allthemodium.registry.TagRegistry;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ShapedAncientStones {
    private final String criteriaName;
    private final Criterion<InventoryChangeTrigger.TriggerInstance> criterion;
    private final EnumMap<Slot, Item> pieces = new EnumMap(Slot.class);
    private final TagKey<Item> ancientstone;

    public ShapedAncientStones(TagKey<Item> ancientstone) {
        this.ancientstone = ancientstone;
        this.criteriaName = String.format("has_%s_block", TagRegistry.ANCIENT_STONE.toString());
        ItemPredicate predicate = ItemPredicate.Builder.item().of(ancientstone).build();
        this.criterion = InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static ShapedAncientStones builder(TagKey<Item> ancientstone) {
        return new ShapedAncientStones(ancientstone);
    }

    public ShapedAncientStones setBookShelf(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.BOOKSHELF, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setDoor(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.DOOR, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setTrapDoor(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.TRAPDOOR, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setBrick(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.BRICK, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setStairs(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.STAIRS, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setFence(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.FENCE, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setFenceGate(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.FENCEGATE, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setSlab(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.SLAB, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setWall(DeferredHolder<Item, BlockItem> object) {
        this.pieces.put(Slot.WALL, (Item)object.get());
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pieces.isEmpty()) {
            throw new RecipeException(id.toString(), "recipe must have at least 1 output");
        }
    }

    public void build(RecipeOutput consumer) {
        Consumer<ShapedRecipeBuilder> register = builder -> builder.save(consumer);
        Optional.ofNullable(this.pieces.get((Object)Slot.BOOKSHELF)).map(this::bookshelf).map(this::addBookCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.TRAPDOOR)).map(this::trapdoor).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.WALL)).map(this::wall).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.BRICK)).map(this::brick).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.SLAB)).map(this::slab).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.DOOR)).map(this::door).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.STAIRS)).map(this::stairs).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.FENCE)).map(this::fence).map(this::addStickCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.FENCEGATE)).map(this::fencegate).map(this::addStickCriterion).ifPresent(register);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider, int integer) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)provider, (int)integer).group("allthemodium");
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)provider).group("allthemodium");
    }

    private ShapedRecipeBuilder addCriterion(ShapedRecipeBuilder builder) {
        return builder.define(Character.valueOf('a'), this.ancientstone).unlockedBy(this.criteriaName, this.criterion);
    }

    private ShapedRecipeBuilder addStickCriterion(ShapedRecipeBuilder builder) {
        return builder.define(Character.valueOf('a'), this.ancientstone).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.criteriaName, this.criterion);
    }

    private ShapedRecipeBuilder addBookCriterion(ShapedRecipeBuilder builder) {
        return builder.define(Character.valueOf('a'), this.ancientstone).define(Character.valueOf('b'), (ItemLike)Items.BOOK).unlockedBy(this.criteriaName, this.criterion);
    }

    private ShapedRecipeBuilder bookshelf(ItemLike provider) {
        return this.shaped(provider).pattern("aaa").pattern("bbb").pattern("aaa");
    }

    private ShapedRecipeBuilder fence(ItemLike provider) {
        return this.shaped(provider, 3).pattern("   ").pattern("asa").pattern("asa");
    }

    private ShapedRecipeBuilder trapdoor(ItemLike provider) {
        return this.shaped(provider, 2).pattern("   ").pattern("aaa").pattern("aaa");
    }

    private ShapedRecipeBuilder door(ItemLike provider) {
        return this.shaped(provider, 3).pattern("aa ").pattern("aa ").pattern("aa ");
    }

    private ShapedRecipeBuilder brick(ItemLike provider) {
        return this.shaped(provider, 4).pattern("   ").pattern("aa ").pattern("aa ");
    }

    private ShapedRecipeBuilder fencegate(ItemLike provider) {
        return this.shaped(provider).pattern("   ").pattern("sas").pattern("sas");
    }

    private ShapedRecipeBuilder stairs(ItemLike provider) {
        return this.shaped(provider, 4).pattern("a  ").pattern("aa ").pattern("aaa");
    }

    private ShapedRecipeBuilder wall(ItemLike provider) {
        return this.shaped(provider, 6).pattern("   ").pattern("aaa").pattern("aaa");
    }

    private ShapedRecipeBuilder slab(ItemLike provider) {
        return this.shaped(provider, 6).pattern("   ").pattern("   ").pattern("aaa");
    }

    public static enum Slot {
        BOOKSHELF,
        TRAPDOOR,
        BRICK,
        FENCE,
        FENCEGATE,
        STAIRS,
        WALL,
        SLAB,
        DOOR;


        public String lower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

