/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import sonar.fluxnetworks.common.util.CodecsExtras;

public record FluxDeviceConfigComponent(int networkId, Optional<String> customName, Optional<Integer> priority, Optional<Boolean> surgeMode, Optional<Long> limit, Optional<Boolean> disableLimit) {
    public static final FluxDeviceConfigComponent EMPTY = new FluxDeviceConfigComponent(-1, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static final Codec<FluxDeviceConfigComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecsExtras.NETWORK_ID.fieldOf("network_id").forGetter(FluxDeviceConfigComponent::networkId), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(FluxDeviceConfigComponent::customName), (App)Codec.INT.optionalFieldOf("priority").forGetter(FluxDeviceConfigComponent::priority), (App)Codec.BOOL.optionalFieldOf("surge_mode").forGetter(FluxDeviceConfigComponent::surgeMode), (App)CodecsExtras.NON_NEGATIVE_LONG.optionalFieldOf("limit").forGetter(FluxDeviceConfigComponent::limit), (App)Codec.BOOL.optionalFieldOf("disable_limit").forGetter(FluxDeviceConfigComponent::disableLimit)).apply((Applicative)instance, FluxDeviceConfigComponent::new));
    public static final StreamCodec<ByteBuf, FluxDeviceConfigComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, FluxDeviceConfigComponent::networkId, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), FluxDeviceConfigComponent::customName, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), FluxDeviceConfigComponent::priority, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), FluxDeviceConfigComponent::surgeMode, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_LONG), FluxDeviceConfigComponent::limit, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), FluxDeviceConfigComponent::disableLimit, FluxDeviceConfigComponent::new);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        Optional<Object> optional;
        int oId;
        if (!(obj instanceof FluxDeviceConfigComponent)) return false;
        FluxDeviceConfigComponent fluxDeviceConfigComponent = (FluxDeviceConfigComponent)obj;
        try {
            int n;
            oId = n = fluxDeviceConfigComponent.networkId();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Optional<String> oName = optional = fluxDeviceConfigComponent.customName();
        Optional<Object> oPriority = optional = fluxDeviceConfigComponent.priority();
        Optional<Object> oSurgeMode = optional = fluxDeviceConfigComponent.surgeMode();
        Optional<Object> oLimit = optional = fluxDeviceConfigComponent.limit();
        Optional<Object> oDisableLimit = optional = fluxDeviceConfigComponent.disableLimit();
        if (this.networkId() != oId) return false;
        if (!this.customName().equals(oName)) return false;
        if (!this.priority().equals(oPriority)) return false;
        if (!this.surgeMode().equals(oSurgeMode)) return false;
        if (!this.limit().equals(oLimit)) return false;
        if (!this.disableLimit().equals(oDisableLimit)) return false;
        return true;
    }

    public long getLimit() {
        return this.limit.orElse(0L);
    }

    public int getPriority() {
        return this.priority.orElse(0);
    }

    public FluxDeviceConfigComponent withNetwork(int networkId) {
        return new FluxDeviceConfigComponent(networkId, this.customName, this.priority, this.surgeMode, this.limit, this.disableLimit);
    }

    public FluxDeviceConfigComponent withNetworkAndName(int networkId, @Nonnull String name) {
        return new FluxDeviceConfigComponent(networkId, Optional.of(name), this.priority, this.surgeMode, this.limit, this.disableLimit);
    }
}

