/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.silentchaos512.lib.util.MathUtils;

public final class AttributeHelper {
    private AttributeHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void apply(LivingEntity entity, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance instance = entity.getAttribute(Holder.direct((Object)attribute));
        AttributeHelper.apply(instance, modifier);
    }

    public static void apply(@Nullable AttributeInstance attributeInstance, AttributeModifier modifier) {
        if (attributeInstance == null) {
            return;
        }
        AttributeModifier currentMod = attributeInstance.getModifier(modifier.id());
        if (!(currentMod == null || MathUtils.doublesEqual(currentMod.amount(), modifier.amount()) && currentMod.operation() == modifier.operation())) {
            attributeInstance.removeModifier(currentMod.id());
        } else {
            attributeInstance.addPermanentModifier(modifier);
        }
    }

    public static void remove(LivingEntity entity, Attribute attribute, ResourceLocation id) {
        AttributeInstance instance = entity.getAttribute(Holder.direct((Object)attribute));
        AttributeHelper.remove(instance, id);
    }

    public static void remove(@Nullable AttributeInstance attributeInstance, ResourceLocation id) {
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.removeModifier(id);
    }
}

