/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TrailEffect {
    private static final int MAX_CAPACITY = 65536;
    private final ArrayList<TrailPoint> points = new ArrayList();
    private final ArrayList<TrailPoint> renderPoints = new ArrayList();
    private final float width;
    private float oldLength;
    private float length;

    public float getWidth() {
        return this.width;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public TrailEffect(float width, int length) {
        this.width = width;
        this.length = length;
    }

    public void update(TrailPoint point) {
        if (this.points.isEmpty() || this.points.getFirst().pos().distanceTo(point.pos()) > 0.01) {
            this.points.addFirst(point);
        }
        if (this.points.size() > 65536) {
            this.points.removeLast();
        }
    }

    public void update(Vec3 pos) {
        this.oldLength = this.length;
        this.update(new TrailPoint(pos, 1.0f));
    }

    public void prepareRender(Vec3 pos, float partialTicks) {
        this.renderPoints.clear();
        this.renderPoints.addAll(this.points);
        this.prepare(new TrailPoint(pos), partialTicks);
    }

    private void prepare(TrailPoint point, float partialTicks) {
        ArrayList<TrailPoint> modified = new ArrayList<TrailPoint>();
        this.renderPoints.addFirst(point);
        float totalLength = 0.0f;
        float renderLength = Mth.lerp((float)partialTicks, (float)this.oldLength, (float)this.length);
        for (int i = 0; i < this.renderPoints.size() - 1; ++i) {
            TrailPoint from = this.renderPoints.get(i);
            TrailPoint to = this.renderPoints.get(i + 1);
            float distance = (float)from.pos().distanceTo(to.pos());
            if (!((totalLength += distance) > renderLength)) continue;
            this.renderPoints.set(i + 1, this.interpolateTrailPoint((totalLength - renderLength) / distance, to, from));
            modified.addAll(this.renderPoints.subList(0, i + 2));
            totalLength = renderLength;
            break;
        }
        if (!modified.isEmpty()) {
            this.renderPoints.clear();
            this.renderPoints.addAll(modified);
        }
        float currentLength = 0.0f;
        for (int i = 0; i < this.renderPoints.size() - 1; ++i) {
            TrailPoint from = this.renderPoints.get(i);
            TrailPoint to = this.renderPoints.get(i + 1);
            float distance = (float)from.pos().distanceTo(to.pos());
            this.renderPoints.set(i, this.renderPoints.get(i).withAlphaFactor((totalLength - currentLength) / renderLength));
            currentLength += distance;
        }
        if (this.renderPoints.size() > 1) {
            this.renderPoints.set(this.renderPoints.size() - 1, this.renderPoints.getLast().withAlphaFactor(0.01f));
        }
    }

    private TrailPoint interpolateTrailPoint(float progress, TrailPoint first, TrailPoint second) {
        return new TrailPoint(ESMathUtil.lerpVec(progress, first.pos(), second.pos()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(VertexConsumer consumer, PoseStack stack, float r, float g, float b, float a, int light) {
        if (this.renderPoints.size() >= 2) {
            for (int i = 0; i < this.renderPoints.size() - 1; ++i) {
                TrailPoint from = this.renderPoints.get(i);
                TrailPoint to = this.renderPoints.get(i + 1);
                Vec3 fromDelta = to.pos().subtract(from.pos());
                Vec3 toDelta = i == this.renderPoints.size() - 2 ? fromDelta : this.renderPoints.get(i + 2).pos().subtract(to.pos());
                PoseStack.Pose pose = stack.last();
                consumer.addVertex(pose, (float)from.getUpperPoint((Vec3)fromDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).x, (float)from.getUpperPoint((Vec3)fromDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).y, (float)from.getUpperPoint((Vec3)fromDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).z).setColor(r, g, b, Mth.clamp((float)(a * from.alphaFactor()), (float)0.0f, (float)1.0f)).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose, (float)to.getUpperPoint((Vec3)toDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).x, (float)to.getUpperPoint((Vec3)toDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).y, (float)to.getUpperPoint((Vec3)toDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).z).setColor(r, g, b, Mth.clamp((float)(a * to.alphaFactor()), (float)0.0f, (float)1.0f)).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose, (float)to.getLowerPoint((Vec3)toDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).x, (float)to.getLowerPoint((Vec3)toDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).y, (float)to.getLowerPoint((Vec3)toDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).z).setColor(r, g, b, Mth.clamp((float)(a * to.alphaFactor()), (float)0.0f, (float)1.0f)).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose, (float)from.getLowerPoint((Vec3)fromDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).x, (float)from.getLowerPoint((Vec3)fromDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).y, (float)from.getLowerPoint((Vec3)fromDelta, (float)this.width, (Camera)Minecraft.getInstance().gameRenderer.getMainCamera()).z).setColor(r, g, b, Mth.clamp((float)(a * from.alphaFactor()), (float)0.0f, (float)1.0f)).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    public record TrailPoint(Vec3 pos, float alphaFactor) {
        public TrailPoint(Vec3 pos) {
            this(pos, 1.0f);
        }

        public Vec3 getUpperPoint(Vec3 delta, float width, Camera camera) {
            return this.pos.add(delta.cross(new Vec3(camera.getLookVector())).normalize().scale((double)(width / 2.0f)));
        }

        public Vec3 getLowerPoint(Vec3 delta, float width, Camera camera) {
            return this.pos.add(delta.cross(new Vec3(camera.getLookVector())).normalize().scale((double)(-width / 2.0f)));
        }

        public TrailPoint withAlphaFactor(float alpha) {
            return new TrailPoint(this.pos(), alpha);
        }
    }
}

