/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.misc;

import cn.leolezury.eternalstarlight.common.entity.misc.TearBombMinecart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class TearBombMinecartItem
extends Item {
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
            double g;
            RailShape railShape;
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel serverLevel = blockSource.level();
            Vec3 vec3 = blockSource.center();
            double d = vec3.x() + (double)((float)direction.getStepX() * 1.125f);
            double e = Math.floor(vec3.y()) + (double)direction.getStepY();
            double f = vec3.z() + (double)((float)direction.getStepZ() * 1.125f);
            BlockPos blockPos = blockSource.pos().relative(direction);
            BlockState blockState = serverLevel.getBlockState(blockPos);
            RailShape railShape2 = railShape = blockState.getBlock() instanceof BaseRailBlock ? (RailShape)blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            if (blockState.is(BlockTags.RAILS)) {
                g = railShape.isAscending() ? 0.6 : 0.1;
            } else {
                if (!blockState.isAir() || !serverLevel.getBlockState(blockPos.below()).is(BlockTags.RAILS)) {
                    return this.defaultDispenseItemBehavior.dispense(blockSource, itemStack);
                }
                BlockState blockState2 = serverLevel.getBlockState(blockPos.below());
                RailShape railShape22 = blockState2.getBlock() instanceof BaseRailBlock ? (RailShape)blockState2.getValue(((BaseRailBlock)blockState2.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
                g = direction != Direction.DOWN && railShape22.isAscending() ? -0.4 : -0.9;
            }
            TearBombMinecart minecart = new TearBombMinecart((Level)serverLevel, d, e + g, f);
            serverLevel.addFreshEntity((Entity)minecart);
            itemStack.shrink(1);
            return itemStack;
        }

        protected void playSound(BlockSource blockSource) {
            blockSource.level().levelEvent(1000, blockSource.pos(), 0);
        }
    };

    public TearBombMinecartItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos = context.getClickedPos());
        if (!blockState.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RailShape railShape = blockState.getBlock() instanceof BaseRailBlock ? (RailShape)blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            double d = 0.0;
            if (railShape.isAscending()) {
                d = 0.5;
            }
            TearBombMinecart minecart = new TearBombMinecart((Level)serverLevel, (float)blockPos.getX() + 0.5f, (double)((float)blockPos.getY() + 0.0625f) + d, (float)blockPos.getZ() + 0.5f);
            serverLevel.addFreshEntity((Entity)minecart);
            serverLevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockPos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)serverLevel.getBlockState(blockPos.below())));
        }
        itemStack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

