/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.item.interfaces.Swingable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class RageOfStarsItem
extends SwordItem
implements Swingable {
    public RageOfStarsItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    private void performSpecialAttach(LivingEntity entity) {
        LivingEntity livingEntity;
        Entity entity2;
        AABB aabb;
        double range = 20.0;
        Vec3 eyePosition = entity.getEyePosition();
        Vec3 viewVector = entity.getViewVector(1.0f);
        Vec3 vec3 = eyePosition.add(viewVector.x * range, viewVector.y * range, viewVector.z * range);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePosition, (Vec3)vec3, (AABB)(aabb = entity.getBoundingBox().expandTowards(viewVector.scale(range)).inflate(1.0, 1.0, 1.0)), entity1 -> !entity1.isSpectator() && entity1 instanceof LivingEntity, (double)(range * range));
        if (entityHitResult != null && (entity2 = entityHitResult.getEntity()) instanceof LivingEntity && (entity2 = (livingEntity = (LivingEntity)entity2).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity2;
            Vec3 location = livingEntity.position();
            AethersentMeteor.createMeteorShower((Level)serverLevel, entity, livingEntity, location.x, location.y, location.z, 200.0, false);
        }
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.postHurtEnemy(stack, target, attacker);
        this.performSpecialAttach(attacker);
    }

    @Override
    public void swing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        this.performSpecialAttach(entity);
    }
}

