/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.item.combat.ESItemTiers;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DaggerOfHungerItem
extends SwordItem {
    public static final ItemAttributeModifiers DEFAULT_ATTRIBUTE = SwordItem.createAttributes((Tier)ESItemTiers.TOOTH_OF_HUNGER, (int)3, (float)-2.4f);
    public static final ItemAttributeModifiers BONUS_ATTRIBUTE = SwordItem.createAttributes((Tier)ESItemTiers.TOOTH_OF_HUNGER, (int)4, (float)-1.9f);
    public static final ItemAttributeModifiers PENALTY_ATTRIBUTE = SwordItem.createAttributes((Tier)ESItemTiers.TOOTH_OF_HUNGER, (int)2, (float)-2.9f);

    public DaggerOfHungerItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
        final DataComponentMap copy = this.components;
        this.components = new DataComponentMap(){

            @Nullable
            public <T> T get(DataComponentType<? extends T> type) {
                return (T)(type != DataComponents.MAX_DAMAGE && type != DataComponents.DAMAGE ? copy.get(type) : null);
            }

            public Set<DataComponentType<?>> keySet() {
                return copy.keySet().stream().filter(type -> type != DataComponents.MAX_DAMAGE && type != DataComponents.DAMAGE).collect(Collectors.toSet());
            }
        };
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        super.postHurtEnemy(stack, entity, attacker);
        entity.addEffect(new MobEffectInstance(MobEffects.HUNGER, 60));
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.getFoodData().eat(3, 0.0f);
        }
        float hungerLevel = Mth.clamp((float)((Float)stack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue(), (float)-1.0f, (float)1.0f);
        float newHungerLevel = Math.min(1.0f, hungerLevel + 0.05f);
        stack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(newHungerLevel)).build());
        if (newHungerLevel == 1.0f && attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            ESCriteriaTriggers.SATURATE_DAGGER_OF_HUNGER.get().trigger(player);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean bl) {
        float hungerLevel;
        if (entity.tickCount % 1200 == 0) {
            hungerLevel = Mth.clamp((float)((Float)stack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue(), (float)-1.0f, (float)1.0f);
            float newHungerLevel = Math.max(-1.0f, hungerLevel - 0.06f);
            stack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(newHungerLevel)).build());
            if (hungerLevel == -1.0f) {
                entity.hurt(ESDamageTypes.getDamageSource(level, ESDamageTypes.DAGGER_OF_HUNGER), 3.0f);
                newHungerLevel = Math.min(1.0f, newHungerLevel + 0.05f);
                stack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(newHungerLevel)).build());
            }
        }
        if (entity.tickCount % 600 == 0) {
            hungerLevel = Mth.clamp((float)((Float)stack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue(), (float)-1.0f, (float)1.0f);
            int state = Math.min(2, (int)((hungerLevel + 1.0f) * 1.5f));
            ItemAttributeModifiers modifiers = switch (state) {
                case 0 -> PENALTY_ATTRIBUTE;
                case 2 -> BONUS_ATTRIBUTE;
                default -> DEFAULT_ATTRIBUTE;
            };
            stack.applyComponentsAndValidate(DataComponentPatch.builder().set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers).build());
        }
        super.inventoryTick(stack, level, entity, slot, bl);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add(CommonComponents.EMPTY);
        list.add((Component)Component.translatable((String)"tooltip.eternal_starlight.dagger_of_hunger.when_attack").withStyle(ChatFormatting.BLUE));
        list.add((Component)Component.translatable((String)"tooltip.eternal_starlight.dagger_of_hunger.attack_bonus").withStyle(ChatFormatting.BLUE));
        list.add((Component)Component.translatable((String)"tooltip.eternal_starlight.dagger_of_hunger.hurt_player").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        float hungerLevel = Mth.clamp((float)((Float)stack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue(), (float)-1.0f, (float)1.0f);
        return Mth.clamp((int)Math.round(13.0f - (1.0f - hungerLevel) * 13.0f / 2.0f), (int)0, (int)13);
    }

    public int getBarColor(ItemStack stack) {
        float hungerLevel = Mth.clamp((float)((Float)stack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue(), (float)-1.0f, (float)1.0f);
        float progress = Mth.clamp((float)((hungerLevel + 1.0f) / 2.0f), (float)0.0f, (float)1.0f);
        return FastColor.ARGB32.colorFromFloat((float)1.0f, (float)(103.0f * progress / 255.0f), (float)(47.0f * progress / 255.0f), (float)(207.0f * progress / 255.0f));
    }
}

