/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CrescentSpearItem
extends Item {
    public CrescentSpearItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 7.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.7, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return !player.isCreative();
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int useTime = this.getUseDuration(itemStack, livingEntity) - i;
            BlockHitResult result = level.clip(new ClipContext(player.position(), player.position().add(0.0, -5.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            if (useTime >= 10 && (result.getType() != HitResult.Type.MISS || player.isCreative())) {
                float spinStrength = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)itemStack, (LivingEntity)player) + 1.75f;
                if (!level.isClientSide) {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)livingEntity.getUsedItemHand()));
                }
                float yaw = player.getYRot();
                float pitch = player.getXRot();
                float xSpeed = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
                float ySpeed = -Mth.sin((float)(pitch * ((float)Math.PI / 180)));
                float zSpeed = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
                float length = Mth.sqrt((float)(xSpeed * xSpeed + ySpeed * ySpeed + zSpeed * zSpeed));
                player.push((double)(xSpeed *= spinStrength / length), (double)(ySpeed *= spinStrength / length), (double)(zSpeed *= spinStrength / length));
                ESDataAttachments.CRESCENT_SPEAR_DASH.setData((Entity)player, true);
                player.startAutoSpinAttack(20, player.getAttribute(Attributes.ATTACK_DAMAGE) != null ? (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE) * 1.5f : 8.0f, itemStack);
                player.getCooldowns().addCooldown((Item)this, 20);
                player.playSound(ESSoundEvents.CRESCENT_SPEAR_THROW.get());
                if (player.onGround()) {
                    player.move(MoverType.SELF, new Vec3(0.0, 1.2, 0.0));
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public int getEnchantmentValue() {
        return 1;
    }
}

